/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.valueconverter;

import lombok.NonNull;
import org.bbottema.javareflection.util.Function;

public interface ValueFunction<F, T> {
    @NonNull
    public Class<F> getFromType();

    @NonNull
    public Class<T> getTargetType();

    @NonNull
    public T convertValue(@NonNull F var1);

    public static class ValueFunctionImpl<F, T>
    implements ValueFunction<F, T> {
        @NonNull
        protected final Class<F> fromType;
        @NonNull
        protected final Class<T> targetType;
        @NonNull
        private final Function<F, T> converter;

        @Override
        @NonNull
        public final T convertValue(@NonNull F value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueFunction$ValueFunctionImpl.convertValue must not be null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked @NonNull but is null");
            }
            T t = this.converter.apply(value);
            if (t == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueFunction$ValueFunctionImpl.convertValue must not return null");
            }
            return t;
        }

        @Override
        @NonNull
        public Class<F> getFromType() {
            Class<F> clazz = this.fromType;
            if (clazz == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueFunction$ValueFunctionImpl.getFromType must not return null");
            }
            return clazz;
        }

        @Override
        @NonNull
        public Class<T> getTargetType() {
            Class<T> clazz = this.targetType;
            if (clazz == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueFunction$ValueFunctionImpl.getTargetType must not return null");
            }
            return clazz;
        }

        @NonNull
        public Function<F, T> getConverter() {
            Function<F, T> function = this.converter;
            if (function == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueFunction$ValueFunctionImpl.getConverter must not return null");
            }
            return function;
        }

        public ValueFunctionImpl(@NonNull Class<F> fromType, @NonNull Class<T> targetType, @NonNull Function<F, T> converter) {
            if (fromType == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/ValueFunction$ValueFunctionImpl.<init> must not be null");
            }
            if (targetType == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/valueconverter/ValueFunction$ValueFunctionImpl.<init> must not be null");
            }
            if (converter == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/valueconverter/ValueFunction$ValueFunctionImpl.<init> must not be null");
            }
            if (fromType == null) {
                throw new NullPointerException("fromType is marked @NonNull but is null");
            }
            if (targetType == null) {
                throw new NullPointerException("targetType is marked @NonNull but is null");
            }
            if (converter == null) {
                throw new NullPointerException("converter is marked @NonNull but is null");
            }
            this.fromType = fromType;
            this.targetType = targetType;
            this.converter = converter;
        }

        public String toString() {
            String string = "ValueFunction.ValueFunctionImpl(fromType=" + this.getFromType() + ", targetType=" + this.getTargetType() + ")";
            if (string == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/ValueFunction$ValueFunctionImpl.toString must not return null");
            }
            return string;
        }
    }
}

