/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.util.graph;

import java.util.Comparator;
import java.util.List;
import org.bbottema.javareflection.util.graph.Node;

class NodePathComparator<T>
implements Comparator<List<Node<T>>> {
    private static final NodePathComparator<?> INSTANCE = new NodePathComparator();

    static <T> NodePathComparator<T> INSTANCE() {
        NodePathComparator<?> nodePathComparator = INSTANCE;
        if (nodePathComparator == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/util/graph/NodePathComparator.INSTANCE must not return null");
        }
        return nodePathComparator;
    }

    private NodePathComparator() {
    }

    @Override
    public int compare(List<Node<T>> nodes1, List<Node<T>> nodes2) {
        if (nodes1 == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/util/graph/NodePathComparator.compare must not be null");
        }
        if (nodes2 == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/util/graph/NodePathComparator.compare must not be null");
        }
        return this.sumNodes(nodes1).compareTo(this.sumNodes(nodes2));
    }

    private Integer sumNodes(List<Node<T>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/util/graph/NodePathComparator.sumNodes must not be null");
        }
        Node<T> currentFromNode = null;
        int nodesCost = 0;
        for (Node<T> nodeInPath : nodes) {
            if (currentFromNode != null) {
                nodesCost += currentFromNode.getToNodes().get(nodeInPath).intValue();
            }
            currentFromNode = nodeInPath;
        }
        Integer n = nodesCost;
        if (n == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/util/graph/NodePathComparator.sumNodes must not return null");
        }
        return n;
    }
}

