/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.valueconverter.converters;

import java.util.ArrayList;
import java.util.Collection;
import org.bbottema.javareflection.util.Function;
import org.bbottema.javareflection.valueconverter.ValueFunction;

public final class CharacterConverters {
    public static final Collection<ValueFunction<Character, ?>> CHARACTER_CONVERTERS = CharacterConverters.produceCharacterConverters();

    private static Collection<ValueFunction<Character, ?>> produceCharacterConverters() {
        ArrayList converters = new ArrayList();
        converters.add(new ValueFunction.ValueFunctionImpl<Character, Character>(Character.TYPE, Character.class, Function.Functions.identity()));
        converters.add(new ValueFunction.ValueFunctionImpl<Character, Character>(Character.class, Character.TYPE, Function.Functions.identity()));
        converters.add(new ValueFunction.ValueFunctionImpl<Character, Character>(Character.TYPE, Character.TYPE, Function.Functions.identity()));
        converters.add(new ValueFunction.ValueFunctionImpl<Character, Character>(Character.class, Character.class, Function.Functions.identity()));
        converters.add(new ValueFunction.ValueFunctionImpl<Character, String>(Character.class, String.class, Function.Functions.simpleToString()));
        converters.add(new ValueFunction.ValueFunctionImpl<Character, Number>(Character.class, Number.class, new CharacterToNumberFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<Character, Boolean>(Character.class, Boolean.class, new CharacterToBooleanFunction()));
        ArrayList arrayList = converters;
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/CharacterConverters.produceCharacterConverters must not return null");
        }
        return arrayList;
    }

    private CharacterConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class CharacterToBooleanFunction
    implements Function<Character, Boolean> {
        private CharacterToBooleanFunction() {
        }

        @Override
        public Boolean apply(Character value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/CharacterConverters$CharacterToBooleanFunction.apply must not be null");
            }
            Boolean bl = !value.equals(Character.valueOf('0'));
            if (bl == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/CharacterConverters$CharacterToBooleanFunction.apply must not return null");
            }
            return bl;
        }
    }

    private static class CharacterToNumberFunction
    implements Function<Character, Number> {
        private CharacterToNumberFunction() {
        }

        @Override
        public Number apply(Character value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/CharacterConverters$CharacterToNumberFunction.apply must not be null");
            }
            int numericValue = Character.getNumericValue(value.charValue());
            Integer n = numericValue == -1 || numericValue > 9 ? value.charValue() : numericValue;
            if (n == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/CharacterConverters$CharacterToNumberFunction.apply must not return null");
            }
            return n;
        }
    }
}

