/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.valueconverter.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bbottema.javareflection.util.Function;
import org.bbottema.javareflection.util.MiscUtil;
import org.bbottema.javareflection.valueconverter.ValueFunction;

public final class NumberConverters {
    private static final List<Class<? extends Number>> CONVERTABLE_NUMBER_FROM_CLASSES_JDK7 = MiscUtil.newArrayList(Number.class, AtomicInteger.class, AtomicLong.class, BigDecimal.class, BigInteger.class, Byte.TYPE, Byte.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class);
    private static final Map<Class<?>, Function<Number, ?>> CONVERTERS_BY_TARGET_TYPE = new HashMap<Class<?>, Function<Number, ?>>(){
        {
            this.put(Number.class, new NumberDoubleFunction());
            this.put(Integer.class, new NumberIntegerFunction());
            this.put(Integer.TYPE, new NumberIntegerFunction());
            this.put(Boolean.class, new NumberBooleanFunction());
            this.put(Boolean.TYPE, new NumberBooleanFunction());
            this.put(Float.class, new NumberFloatFunction());
            this.put(Float.TYPE, new NumberFloatFunction());
            this.put(Double.class, new NumberDoubleFunction());
            this.put(Double.TYPE, new NumberDoubleFunction());
            this.put(Long.class, new NumberLongFunction());
            this.put(Long.TYPE, new NumberLongFunction());
            this.put(Byte.class, new NumberByteFunction());
            this.put(Byte.TYPE, new NumberByteFunction());
            this.put(Short.class, new NumberShortFunction());
            this.put(Short.TYPE, new NumberShortFunction());
            this.put(Character.class, new NumberCharacterFunction());
            this.put(Character.TYPE, new NumberCharacterFunction());
            this.put(String.class, Function.Functions.simpleToString());
        }
    };
    public static final Collection<ValueFunction<? extends Number, ?>> NUMBER_CONVERTERS = NumberConverters.produceNumberConverters();

    private static Collection<ValueFunction<? extends Number, ?>> produceNumberConverters() {
        ArrayList valueFunctions = new ArrayList();
        for (Class<? extends Number> numberFromClass : CONVERTABLE_NUMBER_FROM_CLASSES_JDK7) {
            for (Map.Entry<Class<?>, Function<Number, ?>> targetClassConverter : CONVERTERS_BY_TARGET_TYPE.entrySet()) {
                Class<? extends Number> targetClass = targetClassConverter.getKey();
                Function converter = numberFromClass == targetClass || targetClass.isAssignableFrom(numberFromClass) ? Function.Functions.identity() : targetClassConverter.getValue();
                valueFunctions.add(new ValueFunction.ValueFunctionImpl(numberFromClass, targetClass, converter));
            }
        }
        ArrayList arrayList = valueFunctions;
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/NumberConverters.produceNumberConverters must not return null");
        }
        return arrayList;
    }

    private NumberConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class NumberCharacterFunction
    implements Function<Number, Character> {
        @Override
        public Character apply(Number value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberCharacterFunction.apply must not be null");
            }
            Character c = Character.valueOf(Character.forDigit(value.intValue(), 10));
            if (c == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberCharacterFunction.apply must not return null");
            }
            return c;
        }
    }

    public static class NumberShortFunction
    implements Function<Number, Short> {
        @Override
        public Short apply(Number value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberShortFunction.apply must not be null");
            }
            Short s = value.shortValue();
            if (s == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberShortFunction.apply must not return null");
            }
            return s;
        }
    }

    public static class NumberByteFunction
    implements Function<Number, Byte> {
        @Override
        public Byte apply(Number value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberByteFunction.apply must not be null");
            }
            Byte by = value.byteValue();
            if (by == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberByteFunction.apply must not return null");
            }
            return by;
        }
    }

    public static class NumberLongFunction
    implements Function<Number, Long> {
        @Override
        public Long apply(Number value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberLongFunction.apply must not be null");
            }
            Long l = value.longValue();
            if (l == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberLongFunction.apply must not return null");
            }
            return l;
        }
    }

    public static class NumberDoubleFunction
    implements Function<Number, Double> {
        @Override
        public Double apply(Number value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberDoubleFunction.apply must not be null");
            }
            Double d = value.doubleValue();
            if (d == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberDoubleFunction.apply must not return null");
            }
            return d;
        }
    }

    public static class NumberFloatFunction
    implements Function<Number, Float> {
        @Override
        public Float apply(Number value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberFloatFunction.apply must not be null");
            }
            Float f = Float.valueOf(value.floatValue());
            if (f == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberFloatFunction.apply must not return null");
            }
            return f;
        }
    }

    public static class NumberBooleanFunction
    implements Function<Number, Boolean> {
        @Override
        public Boolean apply(Number value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberBooleanFunction.apply must not be null");
            }
            Boolean bl = value.intValue() > 0;
            if (bl == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberBooleanFunction.apply must not return null");
            }
            return bl;
        }
    }

    public static class NumberIntegerFunction
    implements Function<Number, Integer> {
        @Override
        public Integer apply(Number value) {
            if (value == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberIntegerFunction.apply must not be null");
            }
            Integer n = value.intValue();
            if (n == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/valueconverter/converters/NumberConverters$NumberIntegerFunction.apply must not return null");
            }
            return n;
        }
    }
}

