/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.ClassUtils;
import org.bbottema.javareflection.LookupCaches;
import org.bbottema.javareflection.TypeUtils;
import org.bbottema.javareflection.model.InvokableObject;
import org.bbottema.javareflection.model.LookupMode;
import org.bbottema.javareflection.model.MethodModifier;
import org.bbottema.javareflection.util.MiscUtil;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MethodUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodUtils.class);

    @Nullable
    public static <T> T invokeCompatibleMethod(@Nullable Object context, Class<?> datatype, String identifier, Object ... args) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Set<InvokableObject<Method>> iMethods;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.invokeCompatibleMethod must not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.invokeCompatibleMethod must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/MethodUtils.invokeCompatibleMethod must not be null");
        }
        Object[] parameterSignature = TypeUtils.collectTypes(args);
        EnumSet<LookupMode> lookupMode = EnumSet.of(LookupMode.AUTOBOX, LookupMode.CAST_TO_SUPER);
        try {
            iMethods = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterSignature);
        }
        catch (NoSuchMethodException e1) {
            try {
                lookupMode.add(LookupMode.CAST_TO_INTERFACE);
                iMethods = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterSignature);
            }
            catch (NoSuchMethodException e2) {
                try {
                    lookupMode.add(LookupMode.COMMON_CONVERT);
                    iMethods = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterSignature);
                }
                catch (NoSuchMethodException e3) {
                    lookupMode.add(LookupMode.SMART_CONVERT);
                    iMethods = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterSignature);
                }
            }
        }
        for (InvokableObject<Method> iMethod : iMethods) {
            iMethod.getMethod().setAccessible(true);
            try {
                Object[] convertedArgs = ValueConversionHelper.convert(args, iMethod.getCompatibleSignature(), false);
                return MiscUtil.trustedNullableCast(iMethod.getMethod().invoke(context, convertedArgs));
            }
            catch (IncompatibleTypeException incompatibleTypeException) {
            }
        }
        LOGGER.error(String.format("Was unable to find a suitable method on %s for the parameter signature %s", datatype, Arrays.toString(parameterSignature)));
        throw new NoSuchMethodException();
    }

    @NotNull
    public static <T> T invokeCompatibleConstructor(Class<T> datatype, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.invokeCompatibleConstructor must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.invokeCompatibleConstructor must not be null");
        }
        Class<?>[] parameterList = TypeUtils.collectTypes(args);
        T t = MethodUtils.invokeConstructor(datatype, parameterList, args);
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.invokeCompatibleConstructor must not return null");
        }
        return t;
    }

    @NotNull
    public static <T> T invokeConstructor(Class<T> datatype, Class<?>[] parameterSignature, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Set<InvokableObject<Constructor>> iConstructors;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.invokeConstructor must not be null");
        }
        if (parameterSignature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.invokeConstructor must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.invokeConstructor must not be null");
        }
        EnumSet<LookupMode> lookupMode = EnumSet.of(LookupMode.AUTOBOX, LookupMode.CAST_TO_SUPER);
        try {
            iConstructors = MethodUtils.findCompatibleConstructor(datatype, lookupMode, parameterSignature);
        }
        catch (NoSuchMethodException e1) {
            try {
                lookupMode.add(LookupMode.CAST_TO_INTERFACE);
                iConstructors = MethodUtils.findCompatibleConstructor(datatype, lookupMode, parameterSignature);
            }
            catch (NoSuchMethodException e2) {
                try {
                    lookupMode.add(LookupMode.COMMON_CONVERT);
                    iConstructors = MethodUtils.findCompatibleConstructor(datatype, lookupMode, parameterSignature);
                }
                catch (NoSuchMethodException e3) {
                    lookupMode.add(LookupMode.SMART_CONVERT);
                    iConstructors = MethodUtils.findCompatibleConstructor(datatype, lookupMode, parameterSignature);
                }
            }
        }
        for (InvokableObject<Constructor> iConstructor : iConstructors) {
            Object t;
            try {
                Object[] convertedArgs = ValueConversionHelper.convert(args, iConstructor.getCompatibleSignature(), false);
                t = MiscUtil.trustedCast(iConstructor.getMethod().newInstance(convertedArgs));
            }
            catch (IncompatibleTypeException incompatibleTypeException) {
                continue;
            }
            if (t == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.invokeConstructor must not return null");
            }
            return t;
        }
        LOGGER.error(String.format("Was unable to find a suitable constructor on %s for the parameter signature %s", datatype, Arrays.toString(parameterSignature)));
        throw new NoSuchMethodException();
    }

    public static <T> Set<InvokableObject<Constructor>> findCompatibleConstructor(Class<T> datatype, EnumSet<LookupMode> lookupMode, Class<?> ... signature) throws NoSuchMethodException {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.findCompatibleConstructor must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.findCompatibleConstructor must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.findCompatibleConstructor must not be null");
        }
        Set<InvokableObject<Constructor>> iConstructors = MethodUtils.getConstructorFromCache(datatype, datatype.getName(), signature);
        if (iConstructors != null) {
            Set<InvokableObject<Constructor>> set = iConstructors;
            if (set == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findCompatibleConstructor must not return null");
            }
            return set;
        }
        iConstructors = new HashSet<InvokableObject<Constructor>>();
        try {
            iConstructors.add(new InvokableObject<Constructor<T>>(datatype.getConstructor(signature), signature, signature));
        }
        catch (NoSuchMethodException e) {
            for (Class<?>[] compatibleSignature : TypeUtils.generateCompatibleTypeLists(lookupMode, signature)) {
                try {
                    iConstructors.add(new InvokableObject<Constructor<T>>(datatype.getConstructor(compatibleSignature), signature, compatibleSignature));
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        if (!iConstructors.isEmpty()) {
            Set<InvokableObject<Constructor>> set = MethodUtils.addMethodToCache(datatype, datatype.getName(), iConstructors, signature);
            if (set == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findCompatibleConstructor must not return null");
            }
            return set;
        }
        throw new NoSuchMethodException();
    }

    @NotNull
    public static Set<InvokableObject<Method>> findSimpleCompatibleMethod(Class<?> datatype, String methodName, Class<?> ... signature) {
        Set<InvokableObject<Method>> set;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.findSimpleCompatibleMethod must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.findSimpleCompatibleMethod must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.findSimpleCompatibleMethod must not be null");
        }
        try {
            set = MethodUtils.findCompatibleMethod(datatype, methodName, EnumSet.noneOf(LookupMode.class), signature);
        }
        catch (NoSuchMethodException e) {
            HashSet<InvokableObject<Method>> hashSet = new HashSet<InvokableObject<Method>>();
            if (hashSet == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findSimpleCompatibleMethod must not return null");
            }
            return hashSet;
        }
        if (set == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findSimpleCompatibleMethod must not return null");
        }
        return set;
    }

    @NotNull
    public static Set<InvokableObject<Method>> findCompatibleMethod(Class<?> datatype, String methodName, EnumSet<LookupMode> lookupMode, Class<?> ... signature) throws NoSuchMethodException {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not be null");
        }
        Set<InvokableObject<Method>> iMethods = MethodUtils.getMethodFromCache(datatype, methodName, signature);
        if (iMethods != null) {
            Set<InvokableObject<Method>> set = iMethods;
            if (set == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not return null");
            }
            return set;
        }
        iMethods = new HashSet<InvokableObject<Method>>();
        try {
            iMethods.add(new InvokableObject<Method>(MethodUtils.getMethod(datatype, methodName, signature), signature, signature));
        }
        catch (NoSuchMethodException e) {
            for (Class<?>[] compatibleSignature : TypeUtils.generateCompatibleTypeLists(lookupMode, signature)) {
                try {
                    iMethods.add(new InvokableObject<Method>(MethodUtils.getMethod(datatype, methodName, compatibleSignature), signature, compatibleSignature));
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        if (!iMethods.isEmpty()) {
            Set<InvokableObject<Method>> set = MethodUtils.addMethodToCache(datatype, methodName, iMethods, signature);
            if (set == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findCompatibleMethod must not return null");
            }
            return set;
        }
        throw new NoSuchMethodException();
    }

    @NotNull
    public static Method getMethod(Class<?> datatype, String name, Class<?> ... signature) throws NoSuchMethodException {
        Method method;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.getMethod must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.getMethod must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.getMethod must not be null");
        }
        for (Class<?> iface : datatype.getInterfaces()) {
            Method method2;
            try {
                method2 = iface.getMethod(name, signature);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            if (method2 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.getMethod must not return null");
            }
            return method2;
        }
        try {
            method = datatype.getMethod(name, signature);
        }
        catch (NoSuchMethodException e) {
            Method method3 = datatype.getDeclaredMethod(name, signature);
            if (method3 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.getMethod must not return null");
            }
            return method3;
        }
        if (method == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.getMethod must not return null");
        }
        return method;
    }

    public static boolean isMethodCompatible(Method method, EnumSet<LookupMode> lookupMode, Class<?> ... signature) {
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.isMethodCompatible must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.isMethodCompatible must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.isMethodCompatible must not be null");
        }
        Class<?>[] targetSignature = method.getParameterTypes();
        if (signature.length != targetSignature.length) {
            return false;
        }
        return TypeUtils.isTypeListCompatible(signature, targetSignature, lookupMode);
    }

    @Nullable
    private static <T> Set<InvokableObject> getInvokableObjectFromCache(Class<T> datatype, String method, Class<?> ... signature) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.getInvokableObjectFromCache must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.getInvokableObjectFromCache must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.getInvokableObjectFromCache must not be null");
        }
        Map<String, Map<Class<?>[], Set<InvokableObject>>> owner = LookupCaches.METHOD_CACHE.get(datatype);
        if (signature.length > 0 && owner != null && owner.containsKey(method)) {
            return owner.get(method).get(signature);
        }
        return null;
    }

    @Nullable
    private static <T> Set<InvokableObject<Method>> getMethodFromCache(Class<T> datatype, String method, Class<?> ... signature) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.getMethodFromCache must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.getMethodFromCache must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.getMethodFromCache must not be null");
        }
        return (Set)MiscUtil.trustedNullableCast(MethodUtils.getInvokableObjectFromCache(datatype, method, signature));
    }

    @Nullable
    private static <T> Set<InvokableObject<Constructor>> getConstructorFromCache(Class<T> datatype, String method, Class<?> ... signature) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.getConstructorFromCache must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.getConstructorFromCache must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.getConstructorFromCache must not be null");
        }
        return (Set)MiscUtil.trustedNullableCast(MethodUtils.getInvokableObjectFromCache(datatype, method, signature));
    }

    private static <T extends InvokableObject<T2>, T2 extends AccessibleObject> Set<T> addMethodToCache(Class<?> datatype, String method, Set<T> methodInvocationCandidates, Class<?> ... signature) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.addMethodToCache must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.addMethodToCache must not be null");
        }
        if (methodInvocationCandidates == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.addMethodToCache must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/MethodUtils.addMethodToCache must not be null");
        }
        if (signature.length > 0) {
            LinkedHashMap<String, Map> owner = LookupCaches.METHOD_CACHE.get(datatype);
            owner = owner != null ? owner : new LinkedHashMap<String, Map>();
            Map methods = (Map)owner.get(method);
            methods = methods != null ? methods : new LinkedHashMap();
            methods.put(signature, MiscUtil.trustedCast(methodInvocationCandidates));
            methods.put(signature, MiscUtil.trustedCast(methodInvocationCandidates));
            owner.put(method, methods);
            LookupCaches.METHOD_CACHE.put(datatype, owner);
        }
        Set<T> set = methodInvocationCandidates;
        if (set == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.addMethodToCache must not return null");
        }
        return set;
    }

    public static Set<Method> findMatchingMethods(Class<?> datatype, @Nullable Class<?> boundaryMarker, String methodName, List<String> paramTypeNames) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.findMatchingMethods must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.findMatchingMethods must not be null");
        }
        if (paramTypeNames == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/MethodUtils.findMatchingMethods must not be null");
        }
        Set<Method> set = MethodUtils.findMatchingMethods(datatype, boundaryMarker, methodName, paramTypeNames.toArray(new String[0]));
        if (set == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findMatchingMethods must not return null");
        }
        return set;
    }

    public static Set<Method> findMatchingMethods(Class<?> datatype, @Nullable Class<?> boundaryMarker, String methodName, String ... paramTypeNames) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.findMatchingMethods must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/MethodUtils.findMatchingMethods must not be null");
        }
        if (paramTypeNames == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/MethodUtils.findMatchingMethods must not be null");
        }
        HashSet<Method> matchingMethods = new HashSet<Method>();
        for (Method method : ClassUtils.collectMethods(datatype, boundaryMarker, MethodModifier.MATCH_ANY)) {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            if (!method.getName().equals(methodName) || methodParameterTypes.length != paramTypeNames.length || !MethodUtils.typeNamesMatch(methodParameterTypes, paramTypeNames)) continue;
            matchingMethods.add(method);
        }
        HashSet<Method> hashSet = matchingMethods;
        if (hashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/MethodUtils.findMatchingMethods must not return null");
        }
        return hashSet;
    }

    private static boolean typeNamesMatch(Class<?>[] parameterTypes, String[] typeNamesToMatch) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.typeNamesMatch must not be null");
        }
        if (typeNamesToMatch == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.typeNamesMatch must not be null");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            String typeNameToMatch = typeNamesToMatch[i];
            if (parameterType.isArray()) {
                String arrayTypeNameToMatch;
                String string = arrayTypeNameToMatch = typeNameToMatch.endsWith("...") ? typeNameToMatch.substring(0, typeNameToMatch.indexOf("...")) : typeNameToMatch;
                if (!MethodUtils.typeNamesDontMatch(parameterType.getComponentType(), arrayTypeNameToMatch)) continue;
                return false;
            }
            if (!MethodUtils.typeNamesDontMatch(parameterType, typeNameToMatch)) continue;
            return false;
        }
        return true;
    }

    private static boolean typeNamesDontMatch(Class<?> parameterType, String typeNameToMatch) {
        if (parameterType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.typeNamesDontMatch must not be null");
        }
        if (typeNameToMatch == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/MethodUtils.typeNamesDontMatch must not be null");
        }
        return !parameterType.getName().equals(typeNameToMatch) && !parameterType.getSimpleName().equals(typeNameToMatch);
    }

    public static boolean methodHasCollectionParameter(Method m) {
        if (m == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/MethodUtils.methodHasCollectionParameter must not be null");
        }
        for (Class<?> parameterType : m.getParameterTypes()) {
            if (!parameterType.isArray() && !Iterable.class.isAssignableFrom(parameterType) && !Map.class.isAssignableFrom(parameterType)) continue;
            return true;
        }
        return false;
    }

    private MethodUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

