/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.util.graph;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.util.graph.Node;

final class Dijkstra {
    private Dijkstra() {
    }

    public static <T> void findShortestPathToAllOtherNodes(Node<T> startingPoint) {
        if (startingPoint == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/util/graph/Dijkstra.findShortestPathToAllOtherNodes must not be null");
        }
        startingPoint.setCost(0);
        HashSet<Node<T>> settledNodes = new HashSet<Node<T>>();
        HashSet<Node<T>> unsettledNodes = new HashSet<Node<T>>();
        unsettledNodes.add(startingPoint);
        while (unsettledNodes.size() != 0) {
            Node<T> currentNode = Dijkstra.getLowestDistanceNode(unsettledNodes);
            unsettledNodes.remove(currentNode);
            for (Map.Entry<Node<T>, Integer> adjacencyPair : currentNode.getToNodes().entrySet()) {
                Node<T> adjacentNode = adjacencyPair.getKey();
                if (settledNodes.contains(adjacentNode)) continue;
                Integer edgeWeight = adjacencyPair.getValue();
                Dijkstra.calculateMinimumDistance(adjacentNode, edgeWeight, currentNode);
                unsettledNodes.add(adjacentNode);
            }
            settledNodes.add(currentNode);
        }
    }

    private static <T> void calculateMinimumDistance(Node<T> evaluationNode, Integer edgeWeigh, Node<T> sourceNode) {
        if (evaluationNode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/util/graph/Dijkstra.calculateMinimumDistance must not be null");
        }
        if (edgeWeigh == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/util/graph/Dijkstra.calculateMinimumDistance must not be null");
        }
        if (sourceNode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/util/graph/Dijkstra.calculateMinimumDistance must not be null");
        }
        if (sourceNode.getCost() + edgeWeigh < evaluationNode.getCost()) {
            evaluationNode.setCost(sourceNode.getCost() + edgeWeigh);
            LinkedList<Node<T>> shortestPath = new LinkedList<Node<T>>(sourceNode.getLeastExpensivePath());
            shortestPath.add(sourceNode);
            evaluationNode.setLeastExpensivePath(shortestPath);
        }
    }

    private static <T> Node<T> getLowestDistanceNode(Set<Node<T>> unsettledNodes) {
        if (unsettledNodes == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/util/graph/Dijkstra.getLowestDistanceNode must not be null");
        }
        Node<T> lowestDistanceNode = null;
        int lowestDistance = Integer.MAX_VALUE;
        for (Node<T> node : unsettledNodes) {
            if (node.getCost() >= lowestDistance) continue;
            lowestDistance = node.getCost();
            lowestDistanceNode = node;
        }
        Node<T> node = lowestDistanceNode;
        if (node == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/util/graph/Dijkstra.getLowestDistanceNode must not return null");
        }
        return node;
    }
}

