/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.model.InvokableObject;
import org.bbottema.javareflection.model.LookupMode;
import org.bbottema.javareflection.util.ArrayKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupCaches {
    static final Map<String, Class<?>> CLASS_CACHE = new HashMap();
    static final Map<Class<?>, Map<String, Map<Class<?>[], Set<InvokableObject>>>> METHOD_CACHE = new LinkedHashMap();
    static final Map<Class<?>, Set<Class<?>>> CACHED_REGISTERED_COMPATIBLE_TARGET_TYPES = new HashMap();
    static final Map<Class<?>, Set<Class<?>>> CACHED_COMPATIBLE_TARGET_TYPES = new HashMap();
    private static final Map<Set<LookupMode>, Map<ArrayKey, List<Class<?>[]>>> CACHED_COMPATIBLE_TYPE_LISTS = new HashMap<Set<LookupMode>, Map<ArrayKey, List<Class<?>[]>>>();

    public static void resetCache() {
        CLASS_CACHE.clear();
        METHOD_CACHE.clear();
        CACHED_REGISTERED_COMPATIBLE_TARGET_TYPES.clear();
        CACHED_COMPATIBLE_TARGET_TYPES.clear();
        CACHED_COMPATIBLE_TYPE_LISTS.clear();
    }

    @Nullable
    static List<Class<?>[]> getCachedCompatibleSignatures(Set<LookupMode> lookupMode, ArrayKey arrayKey) {
        Map<ArrayKey, List<Class<?>[]>> cachedCompatibleSignatures = CACHED_COMPATIBLE_TYPE_LISTS.get(lookupMode);
        if (cachedCompatibleSignatures != null) {
            return cachedCompatibleSignatures.get(arrayKey);
        }
        return null;
    }

    @NotNull
    static List<Class<?>[]> addCompatiblesignaturesToCache(Set<LookupMode> lookupMode, ArrayKey arrayKey, List<Class<?>[]> compatibleTypeLists) {
        Map<ArrayKey, List<Class<?>[]>> cachedCompatibleSignatures = CACHED_COMPATIBLE_TYPE_LISTS.get(lookupMode);
        if (cachedCompatibleSignatures == null) {
            cachedCompatibleSignatures = new HashMap<ArrayKey, List<Class<?>[]>>();
            CACHED_COMPATIBLE_TYPE_LISTS.put(lookupMode, cachedCompatibleSignatures);
        }
        cachedCompatibleSignatures.put(arrayKey, compatibleTypeLists);
        return compatibleTypeLists;
    }
}

