/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.util.graph;

import java.util.Comparator;
import java.util.List;
import org.bbottema.javareflection.util.MiscUtil;
import org.bbottema.javareflection.util.graph.Node;

class NodePathComparator<T>
implements Comparator<List<Node<T>>> {
    private static final NodePathComparator<?> INSTANCE = new NodePathComparator();

    static <T> NodePathComparator<T> INSTANCE() {
        return (NodePathComparator)MiscUtil.trustedCast(INSTANCE);
    }

    private NodePathComparator() {
    }

    @Override
    public int compare(List<Node<T>> nodes1, List<Node<T>> nodes2) {
        return this.sumNodes(nodes1).compareTo(this.sumNodes(nodes2));
    }

    private Integer sumNodes(List<Node<T>> nodes) {
        Node<T> currentFromNode = null;
        int nodesCost = 0;
        for (Node<T> nodeInPath : nodes) {
            if (currentFromNode != null) {
                nodesCost += currentFromNode.getToNodes().get(nodeInPath).intValue();
            }
            currentFromNode = nodeInPath;
        }
        return nodesCost;
    }
}

