/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.model;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EnumSet;

public enum MethodModifier {
    PUBLIC(1),
    PROTECTED(4),
    PRIVATE(2),
    ABSTRACT(1024),
    DEFAULT(-1),
    STATIC(8),
    FINAL(16),
    SYNCHRONIZED(32),
    NATIVE(256),
    STRICT(2048);

    public static final EnumSet<MethodModifier> MATCH_ANY;
    private final int modifierFlag;

    private MethodModifier(int modifierFlag) {
        this.modifierFlag = modifierFlag;
    }

    public static boolean meetsModifierRequirements(Method method, EnumSet<MethodModifier> modifiers) {
        int m = method.getModifiers();
        for (MethodModifier methodModifier : modifiers) {
            if (!(methodModifier != DEFAULT ? (m & methodModifier.modifierFlag) != 0 : !Modifier.isPrivate(m) && !Modifier.isProtected(m) && !Modifier.isPublic(m))) continue;
            return true;
        }
        return false;
    }

    static {
        MATCH_ANY = EnumSet.allOf(MethodModifier.class);
    }
}

