/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.bbottema.javareflection.MethodUtils;
import org.bbottema.javareflection.model.FieldWrapper;
import org.bbottema.javareflection.model.InvokableObject;
import org.bbottema.javareflection.util.commonslang25.StringUtils;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BeanUtils {
    public static boolean isBeanMethod(Method method, Class<?> boundaryMarker, EnumSet<Visibility> visibility) {
        return BeanUtils.isBeanMethod(method, boundaryMarker, visibility, false);
    }

    public static boolean isBeanMethod(Method method, Class<?> boundaryMarker, EnumSet<Visibility> visibility, boolean checkBeanLikeForInterfaces) {
        return method.getDeclaringClass().isInterface() ? checkBeanLikeForInterfaces && BeanUtils.methodIsBeanlike(method) : BeanUtils.isBeanMethodForField(method, boundaryMarker, visibility);
    }

    private static boolean isBeanMethodForField(Method method, Class<?> boundaryMarker, EnumSet<Visibility> visibility) {
        LinkedHashMap<Class<?>, List<FieldWrapper>> fields = BeanUtils.collectFields(method.getDeclaringClass(), boundaryMarker, visibility, EnumSet.noneOf(BeanRestriction.class));
        for (List fieldWrappers : fields.values()) {
            for (FieldWrapper fieldWrapper : fieldWrappers) {
                if (!method.equals(fieldWrapper.getGetter()) && !method.equals(fieldWrapper.getSetter())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean methodIsBeanlike(Method method) {
        Pattern SET_PATTERN = Pattern.compile("set[A-Z].*?");
        Pattern GET_PATTERN = Pattern.compile("get[A-Z].*?");
        Pattern IS_PATTERN = Pattern.compile("is[A-Z].*?");
        String name = method.getName();
        int paramCount = method.getParameterTypes().length;
        Class<?> rt = method.getReturnType();
        return rt == Boolean.TYPE && IS_PATTERN.matcher(name).matches() && paramCount == 0 || rt != Void.TYPE && rt != Boolean.TYPE && GET_PATTERN.matcher(name).matches() && paramCount == 0 || rt == Void.TYPE && SET_PATTERN.matcher(name).matches() && paramCount == 1;
    }

    @NotNull
    public static LinkedHashMap<Class<?>, List<FieldWrapper>> collectFields(Class<?> _class, Class<?> boundaryMarker, EnumSet<Visibility> visibility, EnumSet<BeanRestriction> beanRestrictions) {
        LinkedHashMap fields = new LinkedHashMap();
        Field[] allFields = _class.getDeclaredFields();
        LinkedList<FieldWrapper> filteredFields = new LinkedList<FieldWrapper>();
        for (Field field : allFields) {
            FieldWrapper property;
            if (!BeanUtils.meetsVisibilityRequirements(field, visibility) || (property = BeanUtils.resolveBeanProperty(field, beanRestrictions)) == null) continue;
            filteredFields.add(property);
        }
        fields.put(_class, filteredFields);
        List<Class<?>> interfaces = Arrays.asList(_class.getInterfaces());
        if (!_class.equals(boundaryMarker) && !interfaces.contains(boundaryMarker)) {
            fields.putAll(BeanUtils.collectFields(_class.getSuperclass(), boundaryMarker, visibility, beanRestrictions));
        }
        return fields;
    }

    static boolean meetsVisibilityRequirements(Field field, EnumSet<Visibility> visibility) {
        int m = field.getModifiers();
        for (Visibility visibilityModifier : visibility) {
            if (!(visibilityModifier != Visibility.DEFAULT ? (m & visibilityModifier.modifierFlag) != 0 : !Modifier.isPrivate(m) && !Modifier.isProtected(m) && !Modifier.isPublic(m))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static FieldWrapper resolveBeanProperty(Field field, EnumSet<BeanRestriction> beanRestrictions) {
        if (beanRestrictions.containsAll(EnumSet.of(BeanRestriction.NO_GETTER, BeanRestriction.YES_GETTER)) || beanRestrictions.containsAll(EnumSet.of(BeanRestriction.NO_SETTER, BeanRestriction.YES_SETTER))) {
            throw new IllegalArgumentException("cannot both include and exclude a setter/getter requirement");
        }
        String setterName = "set" + StringUtils.capitalize(field.getName());
        String getterName = field.getType().equals(Boolean.TYPE) ? "is" + StringUtils.capitalize(field.getName()) : "get" + StringUtils.capitalize(field.getName());
        Set<InvokableObject<Method>> iWriteMethod = MethodUtils.findSimpleCompatibleMethod(field.getDeclaringClass(), setterName, field.getType());
        Set<InvokableObject<Method>> iReadMethod = MethodUtils.findSimpleCompatibleMethod(field.getDeclaringClass(), getterName, new Class[0]);
        if (!(!iReadMethod.isEmpty() && beanRestrictions.contains((Object)BeanRestriction.NO_GETTER) || iReadMethod.isEmpty() && beanRestrictions.contains((Object)BeanRestriction.YES_GETTER) || !iWriteMethod.isEmpty() && beanRestrictions.contains((Object)BeanRestriction.NO_SETTER) || iWriteMethod.isEmpty() && beanRestrictions.contains((Object)BeanRestriction.YES_SETTER))) {
            Method readMethod = !iReadMethod.isEmpty() ? iReadMethod.iterator().next().getMethod() : null;
            Method writeMethod = !iWriteMethod.isEmpty() ? iWriteMethod.iterator().next().getMethod() : null;
            return new FieldWrapper(field, readMethod, writeMethod);
        }
        return null;
    }

    @Nullable
    public static Object invokeBeanSetter(Object o, String fieldName, @Nullable Object value) {
        for (List<FieldWrapper> fieldWrappers : BeanUtils.collectFields(o.getClass(), Object.class, EnumSet.allOf(Visibility.class), EnumSet.of(BeanRestriction.YES_SETTER)).values()) {
            for (FieldWrapper fieldWrapper : fieldWrappers) {
                if (!fieldWrapper.getField().getName().equals(fieldName)) continue;
                Object assignedValue = value;
                try {
                    MethodUtils.invokeMethodSimple(fieldWrapper.getSetter(), o, value);
                }
                catch (IllegalArgumentException ie) {
                    try {
                        assignedValue = ValueConversionHelper.convert(value, fieldWrapper.getField().getType());
                    }
                    catch (IncompatibleTypeException e) {
                        throw new RuntimeException(new NoSuchMethodException(e.getMessage()));
                    }
                    MethodUtils.invokeMethodSimple(fieldWrapper.getSetter(), o, assignedValue);
                }
                return assignedValue;
            }
        }
        throw new RuntimeException(new NoSuchMethodException("Bean setter for " + fieldName));
    }

    public static Object invokeBeanGetter(Object o, String fieldName) {
        for (List<FieldWrapper> fieldWrappers : BeanUtils.collectFields(o.getClass(), Object.class, EnumSet.allOf(Visibility.class), EnumSet.of(BeanRestriction.YES_GETTER)).values()) {
            for (FieldWrapper fieldWrapper : fieldWrappers) {
                if (!fieldWrapper.getField().getName().equals(fieldName)) continue;
                return MethodUtils.invokeMethodSimple(fieldWrapper.getGetter(), o, new Object[0]);
            }
        }
        throw new RuntimeException(new NoSuchMethodException("Bean getter for " + fieldName));
    }

    private BeanUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum BeanRestriction {
        YES_GETTER,
        YES_SETTER,
        NO_SETTER,
        NO_GETTER;

    }

    public static enum Visibility {
        PRIVATE(2),
        DEFAULT(-1),
        PROTECTED(4),
        PUBLIC(1);

        private final int modifierFlag;

        private Visibility(int modifierFlag) {
            this.modifierFlag = modifierFlag;
        }
    }
}

