/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.ClassUtils;
import org.bbottema.javareflection.LookupCaches;
import org.bbottema.javareflection.TypeUtils;
import org.bbottema.javareflection.model.InvokableObject;
import org.bbottema.javareflection.model.LookupMode;
import org.bbottema.javareflection.model.MethodModifier;
import org.bbottema.javareflection.model.MethodParameter;
import org.bbottema.javareflection.util.MiscUtil;
import org.bbottema.javareflection.valueconverter.IncompatibleTypeException;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MethodUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodUtils.class);

    @Nullable
    public static <T> T invokeMethodSimple(Method method, @Nullable Object subject, Object ... args) {
        try {
            return (T)method.invoke(subject, args);
        }
        catch (SecurityException e) {
            throw new RuntimeException("unable to invoke method; security problem", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to access method", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("unable to invoke method", e);
        }
    }

    @Nullable
    public static <T> T invokeCompatibleMethod(@Nullable Object context, Class<?> datatype, String identifier, Object ... args) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Set<InvokableObject<Method>> iMethods;
        Object[] parameterSignature = TypeUtils.collectTypes(args);
        EnumSet<LookupMode> lookupMode = EnumSet.of(LookupMode.AUTOBOX, LookupMode.CAST_TO_SUPER);
        try {
            iMethods = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterSignature);
        }
        catch (NoSuchMethodException e1) {
            try {
                lookupMode.add(LookupMode.CAST_TO_INTERFACE);
                iMethods = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterSignature);
            }
            catch (NoSuchMethodException e2) {
                try {
                    lookupMode.add(LookupMode.COMMON_CONVERT);
                    iMethods = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterSignature);
                }
                catch (NoSuchMethodException e3) {
                    lookupMode.add(LookupMode.SMART_CONVERT);
                    iMethods = MethodUtils.findCompatibleMethod(datatype, identifier, lookupMode, parameterSignature);
                }
            }
        }
        for (InvokableObject<Method> iMethod : iMethods) {
            iMethod.getMethod().setAccessible(true);
            try {
                Object[] convertedArgs = ValueConversionHelper.convert(args, iMethod.getCompatibleSignature(), false);
                return MiscUtil.trustedNullableCast(iMethod.getMethod().invoke(context, convertedArgs));
            }
            catch (IncompatibleTypeException incompatibleTypeException) {
            }
        }
        LOGGER.error(String.format("Was unable to find a suitable method on %s for the parameter signature %s", datatype, Arrays.toString(parameterSignature)));
        throw new NoSuchMethodException();
    }

    @NotNull
    public static <T> T invokeCompatibleConstructor(Class<T> datatype, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?>[] parameterList = TypeUtils.collectTypes(args);
        return MethodUtils.invokeConstructor(datatype, parameterList, args);
    }

    @NotNull
    public static <T> T invokeConstructor(Class<T> datatype, Class<?>[] parameterSignature, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Set<InvokableObject<Constructor>> iConstructors;
        EnumSet<LookupMode> lookupMode = EnumSet.of(LookupMode.AUTOBOX, LookupMode.CAST_TO_SUPER);
        try {
            iConstructors = MethodUtils.findCompatibleConstructor(datatype, lookupMode, parameterSignature);
        }
        catch (NoSuchMethodException e1) {
            try {
                lookupMode.add(LookupMode.CAST_TO_INTERFACE);
                iConstructors = MethodUtils.findCompatibleConstructor(datatype, lookupMode, parameterSignature);
            }
            catch (NoSuchMethodException e2) {
                try {
                    lookupMode.add(LookupMode.COMMON_CONVERT);
                    iConstructors = MethodUtils.findCompatibleConstructor(datatype, lookupMode, parameterSignature);
                }
                catch (NoSuchMethodException e3) {
                    lookupMode.add(LookupMode.SMART_CONVERT);
                    iConstructors = MethodUtils.findCompatibleConstructor(datatype, lookupMode, parameterSignature);
                }
            }
        }
        for (InvokableObject<Constructor> iConstructor : iConstructors) {
            try {
                Object[] convertedArgs = ValueConversionHelper.convert(args, iConstructor.getCompatibleSignature(), false);
                return MiscUtil.trustedCast(iConstructor.getMethod().newInstance(convertedArgs));
            }
            catch (IncompatibleTypeException incompatibleTypeException) {
            }
        }
        LOGGER.error(String.format("Was unable to find a suitable constructor on %s for the parameter signature %s", datatype, Arrays.toString(parameterSignature)));
        throw new NoSuchMethodException();
    }

    public static <T> Set<InvokableObject<Constructor>> findCompatibleConstructor(Class<T> datatype, Set<LookupMode> lookupMode, Class<?> ... signature) throws NoSuchMethodException {
        Set<InvokableObject<Constructor>> iConstructors = MethodUtils.getConstructorFromCache(datatype, datatype.getName(), signature);
        if (iConstructors != null) {
            return iConstructors;
        }
        iConstructors = new HashSet<InvokableObject<Constructor>>();
        try {
            iConstructors.add(new InvokableObject<Constructor<T>>(datatype.getConstructor(signature), signature, signature));
        }
        catch (NoSuchMethodException e) {
            for (Class<?>[] compatibleSignature : TypeUtils.generateCompatibleTypeLists(lookupMode, signature)) {
                try {
                    iConstructors.add(new InvokableObject<Constructor<T>>(datatype.getConstructor(compatibleSignature), signature, compatibleSignature));
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        if (!iConstructors.isEmpty()) {
            return MethodUtils.addMethodToCache(datatype, datatype.getName(), iConstructors, signature);
        }
        throw new NoSuchMethodException();
    }

    @NotNull
    public static Set<InvokableObject<Method>> findSimpleCompatibleMethod(Class<?> datatype, String methodName, Class<?> ... signature) {
        try {
            return MethodUtils.findCompatibleMethod(datatype, methodName, EnumSet.noneOf(LookupMode.class), signature);
        }
        catch (NoSuchMethodException e) {
            return new HashSet<InvokableObject<Method>>();
        }
    }

    public static Set<InvokableObject<Method>> findCompatibleMethod(Class<?> datatype, String methodName, Set<LookupMode> lookupMode, Object ... args) throws NoSuchMethodException {
        return MethodUtils.findCompatibleMethod(datatype, methodName, lookupMode, TypeUtils.collectTypes(args));
    }

    @NotNull
    public static Set<InvokableObject<Method>> findCompatibleMethod(Class<?> datatype, String methodName, Set<LookupMode> lookupMode, Class<?> ... signature) throws NoSuchMethodException {
        Set<InvokableObject<Method>> iMethods = MethodUtils.getMethodFromCache(datatype, methodName, signature);
        if (iMethods != null) {
            return iMethods;
        }
        iMethods = new HashSet<InvokableObject<Method>>();
        try {
            iMethods.add(new InvokableObject<Method>(MethodUtils.getMethod(datatype, methodName, signature), signature, signature));
        }
        catch (NoSuchMethodException e) {
            for (Class<?>[] compatibleSignature : TypeUtils.generateCompatibleTypeLists(lookupMode, signature)) {
                try {
                    iMethods.add(new InvokableObject<Method>(MethodUtils.getMethod(datatype, methodName, compatibleSignature), signature, compatibleSignature));
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        if (!iMethods.isEmpty()) {
            return MethodUtils.addMethodToCache(datatype, methodName, iMethods, signature);
        }
        throw new NoSuchMethodException();
    }

    @NotNull
    public static Method getMethod(Class<?> datatype, String name, Class<?> ... signature) throws NoSuchMethodException {
        for (Class<?> iface : datatype.getInterfaces()) {
            try {
                return iface.getMethod(name, signature);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        try {
            return datatype.getMethod(name, signature);
        }
        catch (NoSuchMethodException e) {
            return datatype.getDeclaredMethod(name, signature);
        }
    }

    public static boolean isMethodCompatible(Method method, Object ... signature) {
        return MethodUtils.isMethodCompatible(method, LookupMode.SIMPLE, signature);
    }

    public static boolean isMethodCompatible(Method method, Set<LookupMode> lookupMode, Object ... signature) {
        return MethodUtils.isMethodCompatible(method, lookupMode, TypeUtils.collectTypes(signature));
    }

    public static boolean isMethodCompatible(Method method, Class<?> ... signature) {
        return MethodUtils.isMethodCompatible(method, LookupMode.SIMPLE, signature);
    }

    public static boolean isMethodCompatible(Method method, Set<LookupMode> lookupMode, Class<?> ... signature) {
        Class<?>[] targetSignature = method.getParameterTypes();
        if (signature.length != targetSignature.length) {
            return false;
        }
        return TypeUtils.isTypeListCompatible(signature, targetSignature, lookupMode);
    }

    @Nullable
    public static LinkedHashMap<MethodParameter, Object> zipParametersAndArguments(Method method, Object ... arguments) {
        return MethodUtils.zipParametersAndArguments(true, method, arguments);
    }

    @Nullable
    public static LinkedHashMap<MethodParameter, Object> zipParametersAndArguments(boolean strictTypeChecking, Method method, Object ... arguments) {
        if (!strictTypeChecking || MethodUtils.isMethodCompatible(method, arguments)) {
            LinkedHashMap<MethodParameter, Object> result = new LinkedHashMap<MethodParameter, Object>();
            for (int i = 0; i < Math.min(method.getParameterTypes().length, arguments.length); ++i) {
                result.put(new MethodParameter(i, method.getParameterTypes()[i], method.getGenericParameterTypes()[i], Arrays.asList(method.getParameterAnnotations()[i])), arguments[i]);
            }
            return result;
        }
        return null;
    }

    @Nullable
    private static <T> Set<InvokableObject> getInvokableObjectFromCache(Class<T> datatype, String method, Class<?> ... signature) {
        Map<String, Map<Class<?>[], Set<InvokableObject>>> owner = LookupCaches.METHOD_CACHE.get(datatype);
        if (signature.length > 0 && owner != null && owner.containsKey(method)) {
            return owner.get(method).get(signature);
        }
        return null;
    }

    @Nullable
    private static <T> Set<InvokableObject<Method>> getMethodFromCache(Class<T> datatype, String method, Class<?> ... signature) {
        return (Set)MiscUtil.trustedNullableCast(MethodUtils.getInvokableObjectFromCache(datatype, method, signature));
    }

    @Nullable
    private static <T> Set<InvokableObject<Constructor>> getConstructorFromCache(Class<T> datatype, String method, Class<?> ... signature) {
        return (Set)MiscUtil.trustedNullableCast(MethodUtils.getInvokableObjectFromCache(datatype, method, signature));
    }

    private static <T extends InvokableObject<T2>, T2 extends AccessibleObject> Set<T> addMethodToCache(Class<?> datatype, String method, Set<T> methodInvocationCandidates, Class<?> ... signature) {
        if (signature.length > 0) {
            LinkedHashMap<String, Map> owner = LookupCaches.METHOD_CACHE.get(datatype);
            owner = owner != null ? owner : new LinkedHashMap<String, Map>();
            Map methods = (Map)owner.get(method);
            methods = methods != null ? methods : new LinkedHashMap();
            methods.put(signature, MiscUtil.trustedCast(methodInvocationCandidates));
            methods.put(signature, MiscUtil.trustedCast(methodInvocationCandidates));
            owner.put(method, methods);
            LookupCaches.METHOD_CACHE.put(datatype, owner);
        }
        return methodInvocationCandidates;
    }

    public static Set<Method> findMatchingMethods(Class<?> datatype, @Nullable Class<?> boundaryMarker, String methodName, List<String> paramTypeNames) {
        return MethodUtils.findMatchingMethods(datatype, boundaryMarker, methodName, paramTypeNames.toArray(new String[0]));
    }

    public static Set<Method> findMatchingMethods(Class<?> datatype, @Nullable Class<?> boundaryMarker, String methodName, String ... paramTypeNames) {
        HashSet<Method> matchingMethods = new HashSet<Method>();
        for (Method method : ClassUtils.collectMethods(datatype, boundaryMarker, MethodModifier.MATCH_ANY)) {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            if (!method.getName().equals(methodName) || methodParameterTypes.length != paramTypeNames.length || !MethodUtils.typeNamesMatch(methodParameterTypes, paramTypeNames)) continue;
            matchingMethods.add(method);
        }
        return matchingMethods;
    }

    private static boolean typeNamesMatch(Class<?>[] parameterTypes, String[] typeNamesToMatch) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            String typeNameToMatch = typeNamesToMatch[i];
            if (parameterType.isArray()) {
                String arrayTypeNameToMatch;
                String string = arrayTypeNameToMatch = typeNameToMatch.endsWith("...") ? typeNameToMatch.substring(0, typeNameToMatch.indexOf("...")) : typeNameToMatch;
                if (!MethodUtils.typeNamesDontMatch(parameterType.getComponentType(), arrayTypeNameToMatch)) continue;
                return false;
            }
            if (!MethodUtils.typeNamesDontMatch(parameterType, typeNameToMatch)) continue;
            return false;
        }
        return true;
    }

    private static boolean typeNamesDontMatch(Class<?> parameterType, String typeNameToMatch) {
        return !parameterType.getName().equals(typeNameToMatch) && !parameterType.getSimpleName().equals(typeNameToMatch);
    }

    public static boolean methodHasCollectionParameter(Method m) {
        for (Class<?> parameterType : m.getParameterTypes()) {
            if (!parameterType.isArray() && !Iterable.class.isAssignableFrom(parameterType) && !Map.class.isAssignableFrom(parameterType)) continue;
            return true;
        }
        return false;
    }

    public static Method onlyMethod(Set<InvokableObject<Method>> methods) {
        if (methods.size() == 0) {
            return null;
        }
        if (methods.size() == 1) {
            return methods.iterator().next().getMethod();
        }
        throw new AssertionError((Object)("Expected 1 or less methods, but found more than 1 methods: " + methods));
    }

    @Nullable
    public static <T extends Annotation, Target> Target firstParameterArgumentByAnnotation(Method method, Object[] arguments, Class<T> annotationClass) {
        if (MethodUtils.isMethodCompatible(method, arguments)) {
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                if (!TypeUtils.containsAnnotation(method.getParameterAnnotations()[i], annotationClass)) continue;
                return (Target)arguments[i];
            }
        }
        return null;
    }

    public static <T extends Annotation> int firstParameterIndexByAnnotation(Method method, Class<T> annotationClass) {
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (!TypeUtils.containsAnnotation(method.getParameterAnnotations()[i], annotationClass)) continue;
            return i;
        }
        return -1;
    }

    private MethodUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

