/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageFormatException;

public class DBusSignal
extends Message {
    private static Map<Class<? extends DBusSignal>, Type[]> typeCache = new HashMap<Class<? extends DBusSignal>, Type[]>();
    private static Map<String, Class<? extends DBusSignal>> classCache = new HashMap<String, Class<? extends DBusSignal>>();
    private static Map<Class<? extends DBusSignal>, Constructor<? extends DBusSignal>> conCache = new HashMap<Class<? extends DBusSignal>, Constructor<? extends DBusSignal>>();
    private static Map<String, String> signames = new HashMap<String, String>();
    private static Map<String, String> intnames = new HashMap<String, String>();
    private Class<? extends DBusSignal> c;
    private boolean bodydone = false;
    private byte[] blen;

    DBusSignal() {
    }

    public DBusSignal(String source, String path, String iface, String member, String sig, Object ... args) throws DBusException {
        super((byte)66, (byte)4, (byte)0);
        if (null == path || null == member || null == iface) {
            throw new MessageFormatException(Gettext._("Must specify object path, interface and signal name to Signals."));
        }
        this.headers.put((byte)1, path);
        this.headers.put((byte)3, member);
        this.headers.put((byte)2, iface);
        Vector<Object[]> hargs = new Vector<Object[]>();
        hargs.add(new Object[]{(byte)1, new Object[]{"o", path}});
        hargs.add(new Object[]{(byte)2, new Object[]{"s", iface}});
        hargs.add(new Object[]{(byte)3, new Object[]{"s", member}});
        if (null != source) {
            this.headers.put((byte)7, source);
            hargs.add(new Object[]{(byte)7, new Object[]{"s", source}});
        }
        if (null != sig) {
            hargs.add(new Object[]{(byte)8, new Object[]{"g", sig}});
            this.headers.put((byte)8, sig);
            this.setArgs(args);
        }
        this.blen = new byte[4];
        this.appendBytes(this.blen);
        this.append("ua(yv)", ++this.serial, hargs.toArray());
        this.pad((byte)8);
        long c = this.bytecounter;
        if (null != sig) {
            this.append(sig, args);
        }
        this.marshallint(this.bytecounter - c, this.blen, 0, 4);
        this.bodydone = true;
    }

    static void addInterfaceMap(String java, String dbus) {
        intnames.put(dbus, java);
    }

    static void addSignalMap(String java, String dbus) {
        signames.put(dbus, java);
    }

    static DBusSignal createSignal(Class<? extends DBusSignal> c, String source, String objectpath, String sig, long serial, Object ... parameters) throws DBusException {
        String type = "";
        if (null != c.getEnclosingClass()) {
            type = null != c.getEnclosingClass().getAnnotation(DBusInterfaceName.class) ? c.getEnclosingClass().getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(c.getEnclosingClass().getName()).replaceAll(".");
        } else {
            throw new DBusException(Gettext._("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package."));
        }
        internalsig s = new internalsig(source, objectpath, type, c.getSimpleName(), sig, parameters, serial);
        s.c = c;
        return s;
    }

    private static Class<? extends DBusSignal> createSignalClass(String intname, String signame) throws DBusException {
        String name = intname + '$' + signame;
        Class<DBusSignal> c = classCache.get(name);
        if (null == c) {
            c = DBusMatchRule.getCachedSignalType(name);
        }
        if (null != c) {
            return c;
        }
        do {
            try {
                c = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            name = name.replaceAll("\\.([^\\.]*)$", "\\$$1");
        } while (null == c && name.matches(".*\\..*"));
        if (null == c) {
            throw new DBusException(Gettext._("Could not create class from signal ") + intname + '.' + signame);
        }
        classCache.put(name, c);
        return c;
    }

    DBusSignal createReal(AbstractConnection conn) throws DBusException {
        String intname = intnames.get(this.getInterface());
        String signame = signames.get(this.getName());
        if (null == intname) {
            intname = this.getInterface();
        }
        if (null == signame) {
            signame = this.getName();
        }
        if (null == this.c) {
            this.c = DBusSignal.createSignalClass(intname, signame);
        }
        Type[] types = typeCache.get(this.c);
        Constructor<DBusSignal> con = conCache.get(this.c);
        if (null == types) {
            con = this.c.getDeclaredConstructors()[0];
            conCache.put(this.c, con);
            Type[] ts = con.getGenericParameterTypes();
            types = new Type[ts.length - 1];
            for (int i = 1; i < ts.length; ++i) {
                if (ts[i] instanceof TypeVariable) {
                    Type[] typeArray = ((TypeVariable)ts[i]).getBounds();
                    int n = typeArray.length;
                    for (int j = 0; j < n; ++j) {
                        Type b;
                        types[i - 1] = b = typeArray[j];
                    }
                    continue;
                }
                types[i - 1] = ts[i];
            }
            typeCache.put(this.c, types);
        }
        try {
            DBusSignal s;
            Object[] args = Marshalling.deSerializeParameters(this.getParameters(), types, conn);
            if (null == args) {
                s = con.newInstance(this.getPath());
            } else {
                Object[] params = new Object[args.length + 1];
                params[0] = this.getPath();
                System.arraycopy(args, 0, params, 1, args.length);
                s = con.newInstance(params);
            }
            s.headers = this.headers;
            s.wiredata = this.wiredata;
            s.bytecounter = this.wiredata.length;
            return s;
        }
        catch (Exception e) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(e.getMessage());
        }
    }

    protected DBusSignal(String objectpath, Object ... args) throws DBusException {
        super((byte)66, (byte)4, (byte)0);
        if (!objectpath.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$")) {
            throw new DBusException(Gettext._("Invalid object path: ") + objectpath);
        }
        Class<?> tc = this.getClass();
        String member = tc.isAnnotationPresent(DBusMemberName.class) ? tc.getAnnotation(DBusMemberName.class).value() : tc.getSimpleName();
        String iface = null;
        Class<?> enc = tc.getEnclosingClass();
        if (null == enc || !DBusInterface.class.isAssignableFrom(enc) || enc.getName().equals(enc.getSimpleName())) {
            throw new DBusException(Gettext._("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package."));
        }
        iface = null != enc.getAnnotation(DBusInterfaceName.class) ? enc.getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.dollar_pattern.matcher(enc.getName()).replaceAll(".");
        this.headers.put((byte)1, objectpath);
        this.headers.put((byte)3, member);
        this.headers.put((byte)2, iface);
        Vector<Object[]> hargs = new Vector<Object[]>();
        hargs.add(new Object[]{(byte)1, new Object[]{"o", objectpath}});
        hargs.add(new Object[]{(byte)2, new Object[]{"s", iface}});
        hargs.add(new Object[]{(byte)3, new Object[]{"s", member}});
        String sig = null;
        if (0 < args.length) {
            try {
                Type[] types = typeCache.get(tc);
                if (null == types) {
                    Constructor<?> con = tc.getDeclaredConstructors()[0];
                    conCache.put(tc, con);
                    Type[] ts = con.getGenericParameterTypes();
                    types = new Type[ts.length - 1];
                    for (int i = 1; i <= types.length; ++i) {
                        types[i - 1] = ts[i] instanceof TypeVariable ? ((TypeVariable)ts[i]).getBounds()[0] : ts[i];
                    }
                    typeCache.put(tc, types);
                }
                sig = Marshalling.getDBusType(types);
                hargs.add(new Object[]{(byte)8, new Object[]{"g", sig}});
                this.headers.put((byte)8, sig);
                this.setArgs(args);
            }
            catch (Exception e) {
                if (AbstractConnection.EXCEPTION_DEBUG) {
                    // empty if block
                }
                throw new DBusException(Gettext._("Failed to add signal parameters: ") + e.getMessage());
            }
        }
        this.blen = new byte[4];
        this.appendBytes(this.blen);
        this.append("ua(yv)", ++this.serial, hargs.toArray());
        this.pad((byte)8);
    }

    void appendbody(AbstractConnection conn) throws DBusException {
        if (this.bodydone) {
            return;
        }
        Type[] types = typeCache.get(this.getClass());
        Object[] args = Marshalling.convertParameters(this.getParameters(), types, conn);
        this.setArgs(args);
        String sig = this.getSig();
        long c = this.bytecounter;
        if (null != args && 0 < args.length) {
            this.append(sig, args);
        }
        this.marshallint(this.bytecounter - c, this.blen, 0, 4);
        this.bodydone = true;
    }

    static class internalsig
    extends DBusSignal {
        public internalsig(String source, String objectpath, String type, String name, String sig, Object[] parameters, long serial) throws DBusException {
            super(source, objectpath, type, name, sig, parameters, serial);
        }
    }
}

