/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.UInt16;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.test.TestException;
import org.freedesktop.dbus.test.TestNewInterface;
import org.freedesktop.dbus.test.TestRemoteInterface;
import org.freedesktop.dbus.test.TestRemoteInterface2;
import org.freedesktop.dbus.test.TestSerializable;
import org.freedesktop.dbus.test.TestSignalInterface;
import org.freedesktop.dbus.test.TestSignalInterface2;
import org.freedesktop.dbus.test.TestStruct;
import org.freedesktop.dbus.test.TestStruct3;
import org.freedesktop.dbus.test.TestTuple;
import org.freedesktop.dbus.test.test;
import org.freedesktop.dbus.test.testnewclass;

class testclass
implements TestRemoteInterface,
TestRemoteInterface2,
TestSignalInterface,
TestSignalInterface2,
DBus.Properties {
    private DBusConnection conn;

    public testclass(DBusConnection conn) {
        this.conn = conn;
    }

    @Override
    public String Introspect() {
        return "Not XML";
    }

    @Override
    public int[][] teststructstruct(TestStruct3 in) {
        List<List<Integer>> lli = in.b;
        int[][] out = new int[lli.size()][];
        for (int j = 0; j < out.length; ++j) {
            out[j] = new int[lli.get(j).size()];
            for (int k = 0; k < out[j].length; ++k) {
                out[j][k] = lli.get(j).get(k);
            }
        }
        return out;
    }

    @Override
    public float testfloat(float[] f) {
        if (f.length < 4 || f[0] != 17.093f || f[1] != -23.0f || f[2] != 0.0f || f[3] != 31.42f) {
            test.fail("testfloat got incorrect array");
        }
        return f[0];
    }

    @Override
    public void newpathtest(Path p) {
        if (!p.toString().equals("/new/path/test")) {
            test.fail("new path test got wrong path");
        }
    }

    @Override
    public void waitawhile() {
        System.out.println("Sleeping.");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Done sleeping.");
    }

    @Override
    public <A> TestTuple<String, List<Integer>, Boolean> show(A in) {
        System.out.println("Showing Stuff: " + in.getClass() + "(" + in + ")");
        if (!(in instanceof Integer) || (Integer)in != 234) {
            test.fail("show received the wrong arguments");
        }
        DBusCallInfo info = DBusConnection.getCallInfo();
        Vector<Integer> l = new Vector<Integer>();
        l.add(1953);
        return new TestTuple<String, List<Integer>, Boolean>(info.getSource(), l, true);
    }

    @Override
    public <T> T dostuff(TestStruct foo) {
        System.out.println("Doing Stuff " + foo);
        System.out.println(" -- (" + foo.a.getClass() + ", " + foo.b.getClass() + ", " + foo.c.getClass() + ")");
        if (!(foo instanceof TestStruct && foo.a instanceof String && foo.b instanceof UInt32 && foo.c instanceof Variant && "bar".equals(foo.a) && foo.b.intValue() == 52 && foo.c.getValue() instanceof Boolean && ((Boolean)foo.c.getValue()).booleanValue())) {
            test.fail("dostuff received the wrong arguments");
        }
        return (T)foo.c.getValue();
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public List<Integer> sampleArray(List<String> ss, Integer[] is, long[] ls) {
        System.out.println("Got an array:");
        for (String s : ss) {
            System.out.println("--" + s);
        }
        if (!(ss.size() == 5 && "hi".equals(ss.get(0)) && "hello".equals(ss.get(1)) && "hej".equals(ss.get(2)) && "hey".equals(ss.get(3)) && "aloha".equals(ss.get(4)))) {
            test.fail("sampleArray, String array contents incorrect");
        }
        System.out.println("Got an array:");
        for (Integer i : is) {
            System.out.println("--" + i);
        }
        if (is.length != 4 || is[0] != 1 || is[1] != 5 || is[2] != 7 || is[3] != 9) {
            test.fail("sampleArray, Integer array contents incorrect");
        }
        System.out.println("Got an array:");
        for (long l : ls) {
            System.out.println("--" + l);
        }
        if (ls.length != 4 || ls[0] != 2L || ls[1] != 6L || ls[2] != 8L || ls[3] != 12L) {
            test.fail("sampleArray, Integer array contents incorrect");
        }
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(-1);
        vector.add(-5);
        vector.add(-7);
        vector.add(-12);
        vector.add(-18);
        return vector;
    }

    @Override
    public String getName() {
        return "This Is A UTF-8 Name: \u0633 !!";
    }

    @Override
    public String getNameAndThrow() throws TestException {
        throw new TestException("test");
    }

    @Override
    public boolean check() {
        System.out.println("Being checked");
        return false;
    }

    @Override
    public <T> int frobnicate(List<Long> n, Map<String, Map<UInt16, Short>> m, T v) {
        Map<UInt16, Short> mus;
        if (null == n) {
            test.fail("List was null");
        }
        if (n.size() != 3) {
            test.fail("List was wrong size (expected 3, actual " + n.size() + ")");
        }
        if (n.get(0) != 2L || n.get(1) != 5L || n.get(2) != 71L) {
            test.fail("List has wrong contents");
        }
        if (!(v instanceof Integer)) {
            test.fail("v not an Integer");
        }
        if ((Integer)v != 13) {
            test.fail("v is incorrect");
        }
        if (null == m) {
            test.fail("Map was null");
        }
        if (m.size() != 1) {
            test.fail("Map was wrong size");
        }
        if (!m.keySet().contains("stuff")) {
            test.fail("Incorrect key");
        }
        if (null == (mus = m.get("stuff"))) {
            test.fail("Sub-Map was null");
        }
        if (mus.size() != 3) {
            test.fail("Sub-Map was wrong size");
        }
        if (!new Short(5).equals(mus.get(new UInt16(4)))) {
            test.fail("Sub-Map has wrong contents");
        }
        if (!new Short(6).equals(mus.get(new UInt16(5)))) {
            test.fail("Sub-Map has wrong contents");
        }
        if (!new Short(7).equals(mus.get(new UInt16(6)))) {
            test.fail("Sub-Map has wrong contents");
        }
        return -5;
    }

    @Override
    public DBusInterface getThis(DBusInterface t) {
        if (!t.equals(this)) {
            test.fail("Didn't get this properly");
        }
        return this;
    }

    @Override
    public void throwme() throws TestException {
        throw new TestException("test");
    }

    @Override
    public TestSerializable<String> testSerializable(byte b, TestSerializable<String> s, int i) {
        System.out.println("Recieving TestSerializable: " + s);
        if (b != 12 || i != 13 || s.getInt() != 1 || !s.getString().equals("woo") || s.getVector().size() != 3 || s.getVector().get(0) != 1 || s.getVector().get(1) != 2 || s.getVector().get(2) != 3) {
            test.fail("Error in recieving custom synchronisation");
        }
        return s;
    }

    @Override
    public String recursionTest() {
        try {
            TestRemoteInterface tri = this.conn.getRemoteObject("foo.bar.Test", "/Test", TestRemoteInterface.class);
            return tri.getName();
        }
        catch (DBusException DBe) {
            test.fail("Failed with error: " + DBe);
            return "";
        }
    }

    @Override
    public int overload(String s) {
        return 1;
    }

    @Override
    public int overload(byte b) {
        return 2;
    }

    @Override
    public int overload() {
        DBusCallInfo info = DBusConnection.getCallInfo();
        if ("org.freedesktop.dbus.test.AlternateTestInterface".equals(info.getInterface())) {
            return 3;
        }
        if ("org.freedesktop.dbus.test.TestRemoteInterface".equals(info.getInterface())) {
            return 4;
        }
        return -1;
    }

    @Override
    public List<List<Integer>> checklist(List<List<Integer>> lli) {
        return lli;
    }

    @Override
    public TestNewInterface getNew() {
        testnewclass n = new testnewclass();
        try {
            this.conn.exportObject("/new", n);
        }
        catch (DBusException DBe) {
            throw new DBusExecutionException(DBe.getMessage());
        }
        return n;
    }

    @Override
    public void sig(Type[] s) {
        if (!(s.length == 2 && s[0].equals(Byte.class) && s[1] instanceof ParameterizedType && Map.class.equals((Object)((ParameterizedType)s[1]).getRawType()) && ((ParameterizedType)s[1]).getActualTypeArguments().length == 2 && String.class.equals((Object)((ParameterizedType)s[1]).getActualTypeArguments()[0]) && Integer.class.equals((Object)((ParameterizedType)s[1]).getActualTypeArguments()[1]))) {
            test.fail("Didn't send types correctly");
        }
    }

    @Override
    public void complexv(Variant<? extends Object> v) {
        if (!("a{ss}".equals(v.getSig()) && v.getValue() instanceof Map && ((Map)v.getValue()).size() == 1 && "moo".equals(((Map)v.getValue()).get("cow")))) {
            test.fail("Didn't send variant correctly");
        }
    }

    @Override
    public void reg13291(byte[] as, byte[] bs) {
        if (as.length != bs.length) {
            test.fail("didn't receive identical byte arrays");
        }
        for (int i = 0; i < as.length; ++i) {
            if (as[i] == bs[i]) continue;
            test.fail("didn't receive identical byte arrays");
        }
    }

    @Override
    public <A> A Get(String interface_name, String property_name) {
        return (A)new Path("/nonexistant/path");
    }

    @Override
    public <A> void Set(String interface_name, String property_name, A value) {
    }

    @Override
    public Map<String, Variant> GetAll(String interface_name) {
        return new HashMap<String, Variant>();
    }

    @Override
    public Path pathrv(Path a) {
        return a;
    }

    @Override
    public List<Path> pathlistrv(List<Path> a) {
        return a;
    }

    @Override
    public Map<Path, Path> pathmaprv(Map<Path, Path> a) {
        return a;
    }
}

