/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.apigateway;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.MediaType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import nva.commons.apigateway.GatewayResponse;
import nva.commons.apigateway.MediaTypes;
import nva.commons.apigateway.RequestInfo;
import nva.commons.apigateway.RestConfig;
import nva.commons.apigateway.RestRequestHandler;
import nva.commons.apigateway.exceptions.ApiGatewayException;
import nva.commons.apigateway.exceptions.ApiGatewayUncheckedException;
import nva.commons.apigateway.exceptions.GatewayResponseSerializingException;
import nva.commons.apigateway.exceptions.RedirectException;
import nva.commons.apigateway.exceptions.UnsupportedAcceptHeaderException;
import nva.commons.core.Environment;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.StringUtils;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

public abstract class ApiGatewayHandler<I, O>
extends RestRequestHandler<I, O> {
    public static final String ALLOWED_ORIGIN_ENV = "ALLOWED_ORIGIN";
    public static final String MESSAGE_FOR_RUNTIME_EXCEPTIONS_HIDING_IMPLEMENTATION_DETAILS_TO_API_CLIENTS = "Internal server error. Contact application administrator.";
    public static final String DEFAULT_ERROR_MESSAGE = "Unknown error in handler";
    public static final String REQUEST_ID = "requestId";
    public static final Void EMPTY_BODY = null;
    public static final String RESOURCE = "resource";
    public static final String ALL_ORIGINS_ALLOWED = "*";
    public static final String ORIGIN_DELIMITER = ",";
    public static final String FALLBACK_ORIGIN = "https://nva.sikt.no";
    private Supplier<Map<String, String>> additionalSuccessHeadersSupplier = Collections::emptyMap;
    private boolean isBase64Encoded;

    public ApiGatewayHandler(Class<I> iclass, Environment environment) {
        super(iclass, environment, RestConfig.defaultRestObjectMapper);
    }

    @Override
    protected void setAllowedOrigin(RequestInfo requestInfo) {
        this.allowedOrigin = this.readAllowedOrigin(requestInfo);
    }

    private String readAllowedOrigin(RequestInfo requestInfo) {
        List<String> originsList = this.getValidOrigins();
        if (originsList.isEmpty()) {
            return FALLBACK_ORIGIN;
        }
        if (originsList.contains(ALL_ORIGINS_ALLOWED)) {
            return ALL_ORIGINS_ALLOWED;
        }
        return requestInfo.getHeaderOptional("Origin").filter(originsList::contains).orElse(originsList.get(0));
    }

    private List<String> getValidOrigins() {
        return Arrays.stream(this.environment.readEnv(ALLOWED_ORIGIN_ENV).split(ORIGIN_DELIMITER)).map(String::strip).filter(StringUtils::isNotBlank).toList();
    }

    @Override
    protected void writeOutput(I input, O output, RequestInfo requestInfo) throws IOException, UnsupportedAcceptHeaderException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8));){
            Map<String, String> headers = this.getSuccessHeaders(requestInfo);
            Integer statusCode = this.getSuccessStatusCode(input, output);
            String serializedOutput = this.getSerializedOutput(output);
            GatewayResponse gatewayResponse = new GatewayResponse(serializedOutput, headers, (int)statusCode, this.isBase64Encoded);
            String responseJson = this.objectMapper.writeValueAsString(gatewayResponse);
            writer.write(responseJson);
        }
    }

    @Override
    protected void writeExpectedFailure(I input, ApiGatewayException exception, String requestId) throws IOException {
        try {
            if (this.failureIsARedirection(exception)) {
                this.sendRedirectResponse((RedirectException)exception);
            } else {
                this.sendErrorResponse(input, exception, requestId);
            }
        }
        catch (GatewayResponseSerializingException e) {
            throw new ApiGatewayUncheckedException(e);
        }
    }

    @Override
    protected void writeUnexpectedFailure(I input, Exception exception, String requestId) throws IOException {
        try {
            RuntimeException runtimeException = new RuntimeException(MESSAGE_FOR_RUNTIME_EXCEPTIONS_HIDING_IMPLEMENTATION_DETAILS_TO_API_CLIENTS);
            GatewayResponse<ThrowableProblem> response = this.createResponseReportingProblemToClient(runtimeException, 500, requestId);
            this.writeGatewayResponse(response);
        }
        catch (GatewayResponseSerializingException e) {
            throw new ApiGatewayUncheckedException(e);
        }
    }

    protected void setIsBase64Encoded(boolean value) {
        this.isBase64Encoded = value;
    }

    protected ObjectMapper getObjectMapper(RequestInfo requestInfo) throws UnsupportedAcceptHeaderException {
        MediaType mediaType = this.getDefaultResponseContentTypeHeaderValue(requestInfo);
        return this.getObjectMappers().getOrDefault(mediaType, this.objectMapper);
    }

    @JacocoGenerated
    protected Map<MediaType, ObjectMapper> getObjectMappers() {
        return Collections.emptyMap();
    }

    protected void addAdditionalHeaders(Supplier<Map<String, String>> additionalHeaders) {
        this.additionalSuccessHeadersSupplier = additionalHeaders;
    }

    protected Map<String, String> getSuccessHeaders(RequestInfo requestInfo) throws UnsupportedAcceptHeaderException {
        Map<String, String> headers = this.defaultHeaders(requestInfo);
        headers.putAll(this.additionalSuccessHeadersSupplier.get());
        return headers;
    }

    private String getSerializedOutput(O output) throws JsonProcessingException {
        return output instanceof String ? (String)output : this.objectMapper.writeValueAsString(output);
    }

    private void sendErrorResponse(I input, ApiGatewayException exception, String requestId) throws GatewayResponseSerializingException, IOException {
        int statusCode = this.getFailureStatusCode(input, exception);
        GatewayResponse<ThrowableProblem> response = this.createResponseReportingProblemToClient(exception, statusCode, requestId);
        this.writeGatewayResponse(response);
    }

    private void sendRedirectResponse(RedirectException exception) throws GatewayResponseSerializingException, IOException {
        GatewayResponse<Void> response = this.createRedirectResponse(exception);
        this.writeGatewayResponse(response);
    }

    private GatewayResponse<Void> createRedirectResponse(RedirectException exception) throws GatewayResponseSerializingException {
        Map<String, String> responseHeaders = Map.of("Location", exception.getLocation().toString(), "Access-Control-Allow-Origin", this.allowedOrigin);
        return new GatewayResponse<Void>(EMPTY_BODY, responseHeaders, exception.getStatusCode(), this.isBase64Encoded, this.objectMapper);
    }

    private boolean failureIsARedirection(ApiGatewayException exception) {
        return exception instanceof RedirectException;
    }

    private GatewayResponse<ThrowableProblem> createResponseReportingProblemToClient(Exception exception, Integer statusCode, String requestId) throws GatewayResponseSerializingException {
        ThrowableProblem problem = this.createProblemDescription(exception, statusCode, requestId);
        return new GatewayResponse<ThrowableProblem>(problem, this.getFailureHeaders(), statusCode, this.isBase64Encoded, this.objectMapper);
    }

    private <T> void writeGatewayResponse(GatewayResponse<T> gatewayResponse) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, StandardCharsets.UTF_8));){
            String gateWayResponseJson = this.objectMapper.writeValueAsString(gatewayResponse);
            writer.write(gateWayResponseJson);
        }
    }

    private ThrowableProblem createProblemDescription(Exception exception, Integer statusCode, String requestId) {
        String errorMessage = Optional.ofNullable(exception.getMessage()).orElse(this.defaultErrorMessage());
        Status status = Status.valueOf((int)statusCode);
        return Problem.builder().withStatus((StatusType)status).withTitle(status.getReasonPhrase()).withDetail(errorMessage).with(REQUEST_ID, (Object)requestId).with(RESOURCE, this.getResource(exception)).build();
    }

    private Object getResource(Exception exception) {
        Object object;
        if (exception instanceof ApiGatewayException) {
            ApiGatewayException apiGatewayException = (ApiGatewayException)exception;
            object = apiGatewayException.getInstance();
        } else {
            object = null;
        }
        return object;
    }

    private Map<String, String> getFailureHeaders() {
        ConcurrentHashMap<String, String> headers = new ConcurrentHashMap<String, String>();
        headers.put("Access-Control-Allow-Origin", this.allowedOrigin);
        headers.put("Content-Type", MediaTypes.APPLICATION_PROBLEM_JSON.toString());
        headers.put("X-Content-Type-Options", "nosniff");
        headers.put("Strict-Transport-Security", "max-age=63072000; includeSubDomains; preload");
        headers.put("Vary", "Origin, Accept");
        headers.put("Cache-Control", "no-cache");
        return headers;
    }

    private Map<String, String> defaultHeaders(RequestInfo requestInfo) throws UnsupportedAcceptHeaderException {
        ConcurrentHashMap<String, String> headers = new ConcurrentHashMap<String, String>();
        headers.put("Access-Control-Allow-Origin", this.allowedOrigin);
        headers.put("Content-Type", this.getDefaultResponseContentTypeHeaderValue(requestInfo).toString());
        headers.put("X-Content-Type-Options", "nosniff");
        headers.put("Strict-Transport-Security", "max-age=63072000; includeSubDomains; preload");
        headers.put("Vary", "Origin, Accept");
        return headers;
    }

    private String defaultErrorMessage() {
        return String.format("%s, class: %s", DEFAULT_ERROR_MESSAGE, this.getClass().getName());
    }
}

