/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.apigateway;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import nva.commons.apigateway.RequestInfo;
import nva.commons.apigateway.RestConfig;
import nva.commons.apigateway.exceptions.ApiIoException;
import nva.commons.core.JacocoGenerated;

public class ApiMessageParser<T> {
    public static final String COULD_NOT_PARSE_REQUEST_INFO = "Could not parse RequestInfo: ";
    private final transient ObjectMapper mapper;

    @JacocoGenerated
    public ApiMessageParser() {
        this.mapper = RestConfig.defaultRestObjectMapper;
    }

    public ApiMessageParser(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public RequestInfo getRequestInfo(String inputString) throws ApiIoException {
        try {
            return (RequestInfo)this.mapper.readValue(inputString, RequestInfo.class);
        }
        catch (JsonProcessingException e) {
            throw new ApiIoException((IOException)((Object)e), COULD_NOT_PARSE_REQUEST_INFO + inputString);
        }
    }

    public T getBodyElementFromJson(String inputString, Class<T> tclass) throws IOException {
        Optional<JsonNode> tree = Optional.ofNullable(this.mapper.readTree((Reader)new StringReader(inputString)));
        JsonNode body = tree.map(node -> node.get("body")).orElse(null);
        if (body == null) {
            return null;
        }
        if (tclass.equals(String.class)) {
            return (T)body.asText();
        }
        T request = body.isValueNode() ? this.parseBody(this.mapper, body.asText(), tclass) : this.parseBody(this.mapper, body, tclass);
        return request;
    }

    private T parseBody(ObjectMapper mapper, JsonNode node, Class<T> tclass) throws IOException {
        return (T)mapper.readValue((JsonParser)new TreeTraversingParser(node), tclass);
    }

    private T parseBody(ObjectMapper mapper, String json, Class<T> tclass) throws IOException {
        Object object = mapper.readValue(json, tclass);
        return (T)object;
    }
}

