/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.apigateway;

import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import nva.commons.apigateway.AccessRight;
import nva.commons.core.JacocoGenerated;

public class AccessRightEntry {
    public static final int ACCESS_RIGHT_INDEX = 0;
    public static final String ENTRIIES_DELIMITER = ",";
    private static final String AT = "@";
    private static final int CUSTOMER_ID_INDEX = 1;
    private final AccessRight accessRight;
    private final URI customerId;

    public AccessRightEntry(AccessRight accessRight, URI customerId) {
        this.accessRight = accessRight;
        this.customerId = customerId;
    }

    public static AccessRightEntry fromString(String accessRightAtCustomer) {
        String[] list = accessRightAtCustomer.split(AT);
        AccessRight accessRight = AccessRight.fromPersistedString(list[0]);
        URI customerId = URI.create(list[1]);
        return new AccessRightEntry(accessRight, customerId);
    }

    public static Stream<AccessRightEntry> fromCsv(String csv) {
        return Arrays.stream(csv.split(ENTRIIES_DELIMITER)).filter(Predicate.not(String::isBlank)).map(AccessRightEntry::fromString);
    }

    @JacocoGenerated
    public URI getCustomerId() {
        return this.customerId;
    }

    @JacocoGenerated
    public AccessRight getAccessRight() {
        return this.accessRight;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(new Object[]{this.accessRight, this.customerId});
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessRightEntry)) {
            return false;
        }
        AccessRightEntry that = (AccessRightEntry)o;
        return Objects.equals((Object)this.accessRight, (Object)that.accessRight) && Objects.equals(this.customerId, that.customerId);
    }

    public String toString() {
        return this.accessRight.toPersistedString() + AT + this.customerId.toString();
    }
}

