/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.apigateway;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import nva.commons.apigateway.RestConfig;
import nva.commons.apigateway.exceptions.GatewayResponseSerializingException;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;

public class GatewayResponse<T>
implements Serializable {
    private final String body;
    private final Map<String, String> headers;
    private final int statusCode;
    private final boolean isBase64Encoded;

    @JsonCreator
    public GatewayResponse(@JsonProperty(value="body") String body, @JsonProperty(value="headers") Map<String, String> headers, @JsonProperty(value="statusCode") int statusCode, @JsonProperty(value="isBase64Encoded") boolean isBase64Encoded) {
        this.body = body;
        this.headers = headers;
        this.statusCode = statusCode;
        this.isBase64Encoded = isBase64Encoded;
    }

    @JacocoGenerated
    public GatewayResponse(T body, Map<String, String> headers, int statusCode, ObjectMapper objectMapper) throws GatewayResponseSerializingException {
        this(body, headers, statusCode, false, objectMapper);
    }

    public GatewayResponse(T body, Map<String, String> headers, int statusCode, Boolean isBase64Encoded, ObjectMapper objectMapper) throws GatewayResponseSerializingException {
        try {
            this.statusCode = statusCode;
            this.body = body instanceof String ? (String)body : objectMapper.writeValueAsString(body);
            this.headers = Map.copyOf(headers);
            this.isBase64Encoded = isBase64Encoded;
        }
        catch (JsonProcessingException e) {
            throw new GatewayResponseSerializingException((Exception)((Object)e));
        }
    }

    public static <T> GatewayResponse<T> of(ByteArrayOutputStream outputStream) throws JsonProcessingException {
        TypeReference typeReference = new TypeReference<GatewayResponse<T>>(){};
        String json = outputStream.toString(StandardCharsets.UTF_8);
        return (GatewayResponse)RestConfig.defaultRestObjectMapper.readValue(json, typeReference);
    }

    public static <T> GatewayResponse<T> of(InputStream inputStream) throws IOException {
        TypeReference typeReference = new TypeReference<GatewayResponse<T>>(){};
        return (GatewayResponse)RestConfig.defaultRestObjectMapper.readValue(inputStream, typeReference);
    }

    public static <T> GatewayResponse<T> of(String jsonString) throws JsonProcessingException {
        TypeReference typeReference = new TypeReference<GatewayResponse<T>>(){};
        return (GatewayResponse)RestConfig.defaultRestObjectMapper.readValue(jsonString, typeReference);
    }

    public static <T> GatewayResponse<T> fromOutputStream(ByteArrayOutputStream outputStream, Class<T> className) throws JsonProcessingException {
        String json = outputStream.toString(StandardCharsets.UTF_8);
        return GatewayResponse.fromString(json, className);
    }

    @Deprecated(forRemoval=true)
    @JacocoGenerated
    public static <T> GatewayResponse<T> fromOutputStream(ByteArrayOutputStream outputStream) throws JsonProcessingException {
        String json = outputStream.toString(StandardCharsets.UTF_8);
        return GatewayResponse.fromString(json);
    }

    public static <T> GatewayResponse<T> fromString(String responseString, Class<T> className) throws JsonProcessingException {
        return GatewayResponse.isString(className) ? GatewayResponse.constructGatewayResponseWithStringBody(responseString) : GatewayResponse.constructResponseWithJsonObjectBody(responseString);
    }

    @Deprecated(forRemoval=true)
    @JacocoGenerated
    public static <T> GatewayResponse<T> fromString(String responseString) throws JsonProcessingException {
        return GatewayResponse.constructResponseWithJsonObjectBody(responseString);
    }

    public String getBody() {
        return this.body;
    }

    @JsonIgnore
    public T getBodyAsInstance() throws JsonProcessingException {
        return (T)RestConfig.defaultRestObjectMapper.readValue(this.body, new TypeReference<T>(this){});
    }

    public T getBodyObject(Class<T> clazz) throws JsonProcessingException {
        return (T)RestConfig.defaultRestObjectMapper.readValue(this.body, clazz);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Boolean getIsBase64Encoded() {
        return this.isBase64Encoded;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.body, this.headers, this.statusCode, this.isBase64Encoded);
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayResponse that = (GatewayResponse)o;
        return this.statusCode == that.statusCode && Objects.equals(this.body, that.body) && Objects.equals(this.headers, that.headers) && Objects.equals(this.isBase64Encoded, that.isBase64Encoded);
    }

    private static <T> boolean isString(Class<T> className) {
        return className.getTypeName().equals(String.class.getTypeName());
    }

    private static <T> GatewayResponse<T> constructResponseWithJsonObjectBody(String responseString) throws JsonProcessingException {
        TypeReference typeref = new TypeReference<GatewayResponse<T>>(){};
        return (GatewayResponse)RestConfig.defaultRestObjectMapper.readValue(responseString, typeref);
    }

    private static <T> GatewayResponse<T> constructGatewayResponseWithStringBody(String responseString) throws JsonProcessingException {
        JsonNode jsonNode = RestConfig.defaultRestObjectMapper.readTree(responseString);
        String body = jsonNode.get("body").asText();
        TypeReference<Map<String, String>> typeRef = new TypeReference<Map<String, String>>(){};
        Map headers = (Map)RestConfig.defaultRestObjectMapper.convertValue((Object)jsonNode.get("headers"), (TypeReference)typeRef);
        int statusCode = jsonNode.get("statusCode").asInt();
        boolean hasIsBase64EncodedNode = jsonNode.has("isBase64Encoded");
        boolean isBase64Encoded = hasIsBase64EncodedNode && jsonNode.get("isBase64Encoded").asBoolean();
        return (GatewayResponse)Try.attempt(() -> new GatewayResponse<String>(body, headers, statusCode, isBase64Encoded, RestConfig.defaultRestObjectMapper)).orElseThrow();
    }
}

