/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.apigateway;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.Claim;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import no.unit.nva.auth.CognitoUserInfo;
import no.unit.nva.commons.json.JsonUtils;
import nva.commons.apigateway.AccessRight;
import nva.commons.apigateway.ApiMessageParser;
import nva.commons.apigateway.RequestInfoConstants;
import nva.commons.apigateway.RestConfig;
import nva.commons.apigateway.ViewingScope;
import nva.commons.apigateway.exceptions.ApiIoException;
import nva.commons.apigateway.exceptions.BadRequestException;
import nva.commons.apigateway.exceptions.UnauthorizedException;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.StringUtils;
import nva.commons.core.attempt.Try;
import nva.commons.core.ioutils.IoUtils;
import nva.commons.core.paths.UriWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestInfo {
    private static final Logger logger = LoggerFactory.getLogger(RequestInfo.class);
    private static final ObjectMapper mapper = RestConfig.defaultRestObjectMapper;
    private static final String THIRD_PARTY_SCOPE_PREFIX = "https://api.nva.unit.no/scopes/third-party";
    private static final String COMMA = ",";
    private static final String AUTHORIZER_NAME = "authorizer";
    private static final String AUTHORIZER_PATH = "/authorizer";
    private static final String BEARER_PREFIX = "Bearer ";
    private static final String EMPTY_STRING = "";
    @JsonProperty(value="headers")
    private Map<String, String> headers = new HashMap<String, String>();
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="pathParameters")
    private Map<String, String> pathParameters = new HashMap<String, String>();
    @JsonProperty(value="queryStringParameters")
    private Map<String, String> queryParameters = new HashMap<String, String>();
    @JsonProperty(value="multiValueQueryStringParameters")
    private Map<String, List<String>> multiValueQueryStringParameters = new HashMap<String, List<String>>();
    @JsonProperty(value="requestContext")
    private JsonNode requestContext;
    @JsonProperty(value="methodArn")
    private String methodArn;
    @JsonAnySetter
    private Map<String, Object> otherProperties = new LinkedHashMap<String, Object>();

    private RequestInfo() {
        this.requestContext = RestConfig.defaultRestObjectMapper.createObjectNode();
    }

    public static RequestInfo fromRequest(InputStream requestStream) throws ApiIoException {
        String inputString = IoUtils.streamToString((InputStream)requestStream);
        return RequestInfo.fromString(inputString);
    }

    public static RequestInfo fromString(String inputString) throws ApiIoException {
        return new ApiMessageParser(mapper).getRequestInfo(inputString);
    }

    @Deprecated(forRemoval=true)
    public String getHeader(String header) {
        return this.getHeaderOptional(header).orElseThrow(() -> new IllegalArgumentException("Missing from headers: " + header));
    }

    @JsonIgnore
    public Optional<String> getHeaderOptional(String header) {
        return this.getHeaders().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(header)).findFirst().map(Map.Entry::getValue);
    }

    @JsonIgnore
    public String getAuthHeader() {
        return this.getHeaderOptional("Authorization").orElseThrow(() -> new IllegalArgumentException("Missing from headers: Authorization"));
    }

    @JsonIgnore
    public Optional<String> getBearerToken() {
        return this.getHeaderOptional("Authorization").map(authorizationHeader -> authorizationHeader.replaceFirst(BEARER_PREFIX, EMPTY_STRING));
    }

    @JsonIgnore
    public String getQueryParameter(String parameter) throws BadRequestException {
        return this.getQueryParameterOpt(parameter).orElseThrow(() -> new BadRequestException("Missing from query parameters: " + parameter));
    }

    @JsonIgnore
    public List<String> getMultiValueQueryParameter(String parameter) {
        return Optional.ofNullable(this.getMultiValueQueryStringParameters().get(parameter)).orElse(List.of());
    }

    @JsonIgnore
    public Optional<String> getQueryParameterOpt(String parameter) {
        return Optional.ofNullable(this.getQueryParameters()).map(params -> (String)params.get(parameter));
    }

    @JsonIgnore
    public String getPathParameter(String parameter) {
        return Optional.ofNullable(this.getPathParameters().get(parameter)).orElseThrow(() -> new IllegalArgumentException("Missing from pathParameters: " + parameter));
    }

    @JsonIgnore
    public String getRequestContextParameter(JsonPointer jsonPointer) {
        return this.getRequestContextParameterOpt(jsonPointer).orElseThrow(() -> new IllegalArgumentException("Missing from requestContext: " + jsonPointer.toString()));
    }

    @JsonIgnore
    public Optional<String> getRequestContextParameterOpt(JsonPointer jsonPointer) {
        return Optional.ofNullable(this.getRequestContext()).map(context -> context.at(jsonPointer)).filter(Predicate.not(JsonNode::isMissingNode)).filter(Predicate.not(JsonNode::isNull)).map(JsonNode::asText);
    }

    @JacocoGenerated
    public String getMethodArn() {
        return this.methodArn;
    }

    @JacocoGenerated
    public void setMethodArn(String methodArn) {
        this.methodArn = methodArn;
    }

    @JsonAnyGetter
    @JacocoGenerated
    public Map<String, Object> getOtherProperties() {
        return this.otherProperties;
    }

    @JacocoGenerated
    public void setOtherProperties(Map<String, Object> otherProperties) {
        this.otherProperties = otherProperties;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = this.nonNullMap(headers);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public void setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = this.nonNullMap(pathParameters);
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, List<String>> getMultiValueQueryStringParameters() {
        return this.multiValueQueryStringParameters;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = this.nonNullMap(queryParameters);
    }

    public void setMultiValueQueryStringParameters(Map<String, List<String>> multiValueQueryStringParameters) {
        this.multiValueQueryStringParameters = this.nonNullMap(multiValueQueryStringParameters);
    }

    @JacocoGenerated
    public JsonNode getRequestContext() {
        return this.requestContext;
    }

    @JacocoGenerated
    public void setRequestContext(JsonNode requestContext) {
        this.requestContext = Objects.isNull(requestContext) ? RestConfig.defaultRestObjectMapper.createObjectNode() : requestContext;
    }

    @JsonIgnore
    public URI getRequestUri() {
        return new UriWrapper("https", this.getDomainName()).addChild(new String[]{this.getPath()}).addQueryParameters(this.getQueryParameters()).getUri();
    }

    @JsonIgnore
    public String getDomainName() {
        return (String)Try.attempt(() -> this.getRequestContext().get("domainName").asText()).orElseThrow();
    }

    public boolean userIsAuthorized(AccessRight accessRight) {
        return this.getAccessRights().contains((Object)accessRight) || this.handleAuthorizationFailure();
    }

    public boolean isGatewayAuthorized() {
        return this.getRequestContext().has(AUTHORIZER_NAME) && this.getRequestContext().at(AUTHORIZER_PATH).isObject();
    }

    private boolean handleAuthorizationFailure() {
        logger.warn("Missing customerId or required access right");
        return false;
    }

    public List<AccessRight> getAccessRights() {
        return new ArrayList<AccessRight>(this.fetchAccessRights().orElse(Collections.emptyList()));
    }

    private Optional<List<AccessRight>> fetchAccessRights() {
        return this.fetchUserInfo().map(CognitoUserInfo::getAccessRights).map(this::parseAccessRights);
    }

    private Optional<CognitoUserInfo> fetchUserInfo() {
        if (this.isGatewayAuthorized()) {
            JsonNode claims = this.getRequestContext().at("/authorizer/claims");
            return claims.isObject() ? Optional.of(CognitoUserInfo.fromString((String)claims.toString())) : Optional.empty();
        }
        return this.getBearerToken().map(this::getCognitoUserInfoFromToken);
    }

    private CognitoUserInfo getCognitoUserInfoFromToken(String token) {
        Map<String, String> claims = JWT.decode((String)token).getClaims().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> RequestInfo.extractClaimValue((Claim)entry.getValue())));
        return (CognitoUserInfo)Try.attempt(() -> JsonUtils.dtoObjectMapper.writeValueAsString((Object)claims)).map(CognitoUserInfo::fromString).orElseThrow();
    }

    private static String extractClaimValue(Claim value) {
        return Optional.of(value).map(Claim::asString).orElseGet(value::toString);
    }

    private List<AccessRight> parseAccessRights(String value) {
        return Arrays.stream(value.split(COMMA)).filter(array -> !StringUtils.isEmpty((String)array)).map(AccessRight::fromPersistedStringOptional).flatMap(Optional::stream).toList();
    }

    @JsonIgnore
    @Deprecated(forRemoval=true)
    @JacocoGenerated
    public URI getCustomerId() throws UnauthorizedException {
        return this.getCurrentCustomer();
    }

    @Deprecated(since="1.25.5")
    @JsonIgnore
    @JacocoGenerated
    public String getNvaUsername() throws UnauthorizedException {
        return this.getUserName();
    }

    @JsonIgnore
    public String getUserName() throws UnauthorizedException {
        return this.fetchUserName().orElseThrow(UnauthorizedException::new);
    }

    @JsonIgnore
    public String getCognitoUsername() throws UnauthorizedException {
        return this.fetchCognitoUsername().orElseThrow(UnauthorizedException::new);
    }

    @JsonIgnore
    public URI getIssuer() throws UnauthorizedException {
        return this.fetchIssuer().orElseThrow(UnauthorizedException::new);
    }

    @JsonIgnore
    public ViewingScope getViewingScope() throws UnauthorizedException {
        return this.fetchViewingScope().orElseThrow(UnauthorizedException::new);
    }

    @JsonIgnore
    public Optional<String> getFeideId() {
        return this.fetchFeideId();
    }

    @JsonIgnore
    public Optional<URI> getTopLevelOrgCristinId() {
        return this.fetchTopLevelOrgCristinId();
    }

    @JsonIgnore
    public Optional<String> getClientId() {
        if (this.isGatewayAuthorized()) {
            return this.getRequestContextParameterOpt(RequestInfoConstants.CLIENT_ID);
        }
        return this.getClaimFromToken("client_id");
    }

    @JsonIgnore
    public URI getCurrentCustomer() throws UnauthorizedException {
        return this.fetchCustomerId().orElseThrow(UnauthorizedException::new);
    }

    @JsonIgnore
    public List<URI> getAllowedCustomers() throws UnauthorizedException {
        return this.fetchAllowedCustomers().orElseThrow(UnauthorizedException::new);
    }

    @JsonIgnore
    public URI getPersonCristinId() throws UnauthorizedException {
        return this.fetchPersonCristinId().orElseThrow(UnauthorizedException::new);
    }

    @JsonIgnore
    public URI getPersonAffiliation() throws UnauthorizedException {
        return this.fetchPersonAffiliation().orElseThrow(UnauthorizedException::new);
    }

    @JsonIgnore
    public String getPersonNin() {
        return this.fetchPersonNin().orElseThrow(IllegalStateException::new);
    }

    public boolean clientIsInternalBackend() {
        Optional<String> scope = this.isGatewayAuthorized() ? this.getRequestContextParameterOpt(RequestInfoConstants.SCOPES_CLAIM) : this.getClaimFromToken("scope");
        return scope.map(value -> value.contains("https://api.nva.unit.no/scopes/backend")).orElse(false);
    }

    public boolean clientIsThirdParty() {
        Optional<String> scope = this.isGatewayAuthorized() ? this.getRequestContextParameterOpt(RequestInfoConstants.SCOPES_CLAIM) : this.getClaimFromToken("scope");
        return scope.map(this::isThirdPartyScope).orElse(false);
    }

    private Boolean isThirdPartyScope(String scope) {
        return Arrays.stream(scope.split(COMMA)).anyMatch(value -> value.startsWith(THIRD_PARTY_SCOPE_PREFIX));
    }

    private Optional<String> getClaimFromToken(String claim) {
        return this.getBearerToken().map(token -> JWT.decode((String)token).getClaim(claim)).map(Claim::asString);
    }

    private Optional<String> fetchFeideId() {
        return this.fetchUserInfo().map(CognitoUserInfo::getFeideId);
    }

    private Optional<URI> fetchTopLevelOrgCristinId() {
        return this.fetchUserInfo().map(CognitoUserInfo::getTopOrgCristinId);
    }

    private Optional<String> fetchUserName() {
        return this.fetchUserInfo().map(CognitoUserInfo::getUserName);
    }

    private Optional<String> fetchCognitoUsername() {
        return this.fetchUserInfo().map(CognitoUserInfo::getCognitoUsername);
    }

    private Optional<URI> fetchIssuer() {
        return this.fetchUserInfo().map(CognitoUserInfo::getIssuer).map(URI::create);
    }

    private Optional<ViewingScope> fetchViewingScope() {
        return this.fetchUserInfo().map(userInfo -> ViewingScope.from(userInfo.getViewingScopeIncluded(), userInfo.getViewingScopeExcluded()));
    }

    private Optional<URI> fetchPersonCristinId() {
        return this.fetchUserInfo().map(CognitoUserInfo::getPersonCristinId);
    }

    private Optional<URI> fetchPersonAffiliation() {
        return this.fetchUserInfo().map(CognitoUserInfo::getPersonAffiliation);
    }

    private Optional<String> fetchPersonNin() {
        return this.fetchUserInfo().map(CognitoUserInfo::getPersonNin);
    }

    private Optional<URI> fetchCustomerId() {
        return this.fetchUserInfo().map(CognitoUserInfo::getCurrentCustomer);
    }

    private Optional<List<URI>> fetchAllowedCustomers() {
        return this.fetchUserInfo().map(CognitoUserInfo::getAllowedCustomers).map(customers -> customers.split(COMMA)).map(Arrays::stream).map(stream -> stream.map(URI::create).toList());
    }

    private <K, V> Map<K, V> nonNullMap(Map<K, V> map) {
        if (Objects.isNull(map)) {
            return new HashMap();
        }
        return map;
    }
}

