/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.apigateway;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.auth0.jwk.InvalidPublicKeyException;
import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nva.commons.apigateway.ApiMessageParser;
import nva.commons.apigateway.RequestInfo;
import nva.commons.apigateway.exceptions.ApiGatewayException;
import nva.commons.apigateway.exceptions.BadRequestException;
import nva.commons.apigateway.exceptions.GatewayResponseSerializingException;
import nva.commons.apigateway.exceptions.UnauthorizedException;
import nva.commons.apigateway.exceptions.UnsupportedAcceptHeaderException;
import nva.commons.core.Environment;
import nva.commons.core.attempt.Failure;
import nva.commons.core.attempt.Try;
import nva.commons.core.exceptions.ExceptionUtils;
import nva.commons.core.ioutils.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestRequestHandler<I, O>
implements RequestStreamHandler {
    public static final String REQUEST_ID = "RequestId:";
    public static final String SPACE = " ";
    public static final String EMPTY_STRING = "";
    public static final String COMMA = ",";
    public static final String PREFIX_SINGLE_WILDCARD_TYPE = "*/";
    private static final String COGNITO_AUTHORIZER_URLS = "COGNITO_AUTHORIZER_URLS";
    private static final int CONNECT_TIMEOUT = 1000;
    private static final int READ_TIMEOUT = 2000;
    protected final Environment environment;
    private static final Logger logger = LoggerFactory.getLogger(RestRequestHandler.class);
    private final transient Class<I> iclass;
    private final transient ApiMessageParser<I> inputParser;
    protected final ObjectMapper objectMapper;
    private final String[] authorizerUrls;
    private final Map<String, JwkProvider> jwkProviders;
    protected transient OutputStream outputStream;
    protected transient String allowedOrigin;
    private static final List<MediaType> DEFAULT_SUPPORTED_MEDIA_TYPES = List.of(MediaType.JSON_UTF_8);
    private static final String WILDCARD_TYPE = "*";
    public static final String ALLOW_ALL_ORIGINS = "*";

    protected MediaType calculateContentTypeHeaderReturnValue(RequestInfo requestInfo) throws UnsupportedAcceptHeaderException {
        if (requestInfo.getHeaders().containsKey("Accept")) {
            String acceptHeader = requestInfo.getHeaderOptional("Accept").orElseThrow();
            return this.bestMatchingMediaTypeBasedOnRequestAcceptHeader(acceptHeader);
        }
        return this.defaultResponseContentTypeWhenNotSpecifiedByClientRequest();
    }

    private MediaType bestMatchingMediaTypeBasedOnRequestAcceptHeader(String acceptHeader) throws UnsupportedAcceptHeaderException {
        List<MediaType> acceptMediaTypes = this.parseAcceptHeader(acceptHeader);
        List<MediaType> matches = this.findMediaTypeMatches(acceptMediaTypes);
        if (matches.isEmpty()) {
            throw new UnsupportedAcceptHeaderException(acceptMediaTypes, this.listSupportedMediaTypes());
        }
        return matches.get(0);
    }

    private List<MediaType> parseAcceptHeader(String header) {
        return Arrays.stream(header.replace(SPACE, EMPTY_STRING).split(COMMA)).map(this::sanitizeMimeType).map(MediaType::parse).collect(Collectors.toList());
    }

    private String sanitizeMimeType(String mimeType) {
        int index = mimeType.indexOf(59);
        String fullType = (index >= 0 ? mimeType.substring(0, index) : mimeType).trim();
        if (!fullType.isEmpty() && "*".equals(fullType)) {
            return PREFIX_SINGLE_WILDCARD_TYPE + mimeType;
        }
        return mimeType;
    }

    protected List<MediaType> findMediaTypeMatches(List<MediaType> acceptMediaTypes) {
        return this.listSupportedMediaTypes().stream().filter(mediaType -> this.inAcceptedMediaTypeRange((MediaType)mediaType, acceptMediaTypes)).collect(Collectors.toList());
    }

    private boolean inAcceptedMediaTypeRange(MediaType mediaType, List<MediaType> acceptMediaTypes) {
        return acceptMediaTypes.stream().map(MediaType::withoutParameters).anyMatch(arg_0 -> ((MediaType)mediaType).is(arg_0));
    }

    protected List<MediaType> listSupportedMediaTypes() {
        return DEFAULT_SUPPORTED_MEDIA_TYPES;
    }

    protected MediaType getDefaultResponseContentTypeHeaderValue(RequestInfo requestInfo) throws UnsupportedAcceptHeaderException {
        return this.calculateContentTypeHeaderReturnValue(requestInfo);
    }

    private MediaType defaultResponseContentTypeWhenNotSpecifiedByClientRequest() {
        return this.listSupportedMediaTypes().get(0);
    }

    public RestRequestHandler(Class<I> iclass, Environment environment, ObjectMapper objectMapper) {
        this.iclass = iclass;
        this.environment = environment;
        this.inputParser = new ApiMessageParser(objectMapper);
        this.objectMapper = objectMapper;
        this.authorizerUrls = this.environment.readEnv(COGNITO_AUTHORIZER_URLS).split(COMMA);
        this.jwkProviders = this.getJwkProviders(this.authorizerUrls);
    }

    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        logger.info(REQUEST_ID + context.getAwsRequestId());
        Object inputObject = null;
        try {
            this.init(outputStream, context);
            String inputString = IoUtils.streamToString((InputStream)inputStream);
            inputObject = Try.attempt(() -> this.parseInput(inputString)).orElseThrow(this::parsingExceptionToBadRequestException);
            RequestInfo requestInfo = RequestInfo.fromString(inputString);
            this.validateAuthorization(requestInfo);
            this.setAllowedOrigin(requestInfo);
            this.validateRequest(inputObject, requestInfo, context);
            O response = this.processInput(inputObject, requestInfo, context);
            this.writeOutput(inputObject, response, requestInfo);
        }
        catch (ApiGatewayException e) {
            this.handleExpectedException(context, inputObject, e);
        }
        catch (Exception e) {
            this.handleUnexpectedException(context, inputObject, e);
        }
    }

    private Map<String, JwkProvider> getJwkProviders(String ... authorizerUrls) {
        return Stream.of(authorizerUrls).collect(Collectors.toMap(domain -> domain, RestRequestHandler::createJwkProvider));
    }

    private static JwkProvider createJwkProvider(String domain) {
        return new JwkProviderBuilder(domain).cached(10L, 1L, TimeUnit.HOURS).rateLimited(10L, 1L, TimeUnit.MINUTES).timeouts(1000, 2000).build();
    }

    private void validateAuthorization(RequestInfo requestInfo) throws UnauthorizedException {
        Optional<String> bearerToken = requestInfo.getBearerToken();
        if (bearerToken.isPresent() && !requestInfo.isGatewayAuthorized()) {
            try {
                DecodedJWT decodedJWT = JWT.decode((String)bearerToken.get());
                JwkProvider jwkProvider = this.getJwkProvider(decodedJWT.getIssuer());
                Jwk jwk = jwkProvider.get(decodedJWT.getKeyId());
                Algorithm algorithm = RestRequestHandler.getAlgorithm(jwk, decodedJWT.getAlgorithm());
                JWTVerifier jwtVerifier = JWT.require((Algorithm)algorithm).withIssuer(this.authorizerUrls).build();
                jwtVerifier.verify(decodedJWT);
            }
            catch (JwkException | JWTVerificationException e) {
                logger.error("Failed to verify token", e);
                throw new UnauthorizedException("Failed to verify token");
            }
        }
    }

    private static Algorithm getAlgorithm(Jwk jwk, String algorithm) throws InvalidPublicKeyException, UnauthorizedException {
        return switch (algorithm) {
            case "RS256" -> Algorithm.RSA256((RSAKey)((RSAPublicKey)jwk.getPublicKey()));
            case "RS384" -> Algorithm.RSA384((RSAKey)((RSAPublicKey)jwk.getPublicKey()));
            case "RS512" -> Algorithm.RSA512((RSAKey)((RSAPublicKey)jwk.getPublicKey()));
            case "ES256" -> Algorithm.ECDSA256((ECKey)((ECPublicKey)jwk.getPublicKey()));
            case "ES384" -> Algorithm.ECDSA384((ECKey)((ECPublicKey)jwk.getPublicKey()));
            case "ES512" -> Algorithm.ECDSA512((ECKey)((ECPublicKey)jwk.getPublicKey()));
            default -> throw new UnauthorizedException("Unsupported algorithm");
        };
    }

    private JwkProvider getJwkProvider(String issuer) throws UnauthorizedException {
        JwkProvider jwkProvider = this.jwkProviders.get(issuer);
        if (Objects.isNull(jwkProvider)) {
            logger.error("JWK provider for issuer {} not found", (Object)issuer);
            throw new UnauthorizedException("No JWK provider found for issuer");
        }
        return jwkProvider;
    }

    protected abstract void setAllowedOrigin(RequestInfo var1);

    protected abstract void validateRequest(I var1, RequestInfo var2, Context var3) throws ApiGatewayException;

    protected ApiGatewayException parsingExceptionToBadRequestException(Failure<I> fail) {
        return new BadRequestException(fail.getException().getMessage(), fail.getException());
    }

    protected void handleUnexpectedException(Context context, I inputObject, Exception e) throws IOException {
        logger.error(e.getMessage());
        logger.error(ExceptionUtils.stackTraceInSingleLine((Exception)e));
        this.writeUnexpectedFailure(inputObject, e, context.getAwsRequestId());
    }

    protected void handleExpectedException(Context context, I inputObject, ApiGatewayException e) throws IOException {
        logger.warn(e.getMessage());
        logger.warn(ExceptionUtils.stackTraceInSingleLine((Exception)e));
        this.writeExpectedFailure(inputObject, e, context.getAwsRequestId());
    }

    protected void init(OutputStream outputStream, Context context) {
        this.outputStream = outputStream;
        this.allowedOrigin = "*";
    }

    protected abstract O processInput(I var1, RequestInfo var2, Context var3) throws ApiGatewayException;

    protected int getFailureStatusCode(I input, ApiGatewayException error) {
        return error.getStatusCode();
    }

    protected I parseInput(String inputString) throws IOException {
        return this.inputParser.getBodyElementFromJson(inputString, this.getIClass());
    }

    protected abstract Integer getSuccessStatusCode(I var1, O var2);

    protected abstract void writeOutput(I var1, O var2, RequestInfo var3) throws IOException, GatewayResponseSerializingException, UnsupportedAcceptHeaderException;

    protected abstract void writeExpectedFailure(I var1, ApiGatewayException var2, String var3) throws IOException;

    protected abstract void writeUnexpectedFailure(I var1, Exception var2, String var3) throws IOException;

    private Class<I> getIClass() {
        return this.iclass;
    }
}

