/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.apigateway;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import nva.commons.apigateway.exceptions.InvalidAccessRightException;

public enum AccessRight {
    MANAGE_PUBLISHING_REQUESTS("publishing"),
    MANAGE_DEGREE("degree"),
    MANAGE_DEGREE_EMBARGO("degree-embargo"),
    MANAGE_IMPORT("import"),
    MANAGE_DOI("doi"),
    MANAGE_RESOURCES_STANDARD("resource"),
    MANAGE_RESOURCES_ALL("resource-all"),
    MANAGE_OWN_AFFILIATION("own-affiliation"),
    MANAGE_CUSTOMERS("customers"),
    MANAGE_OWN_RESOURCES("resources"),
    MANAGE_NVI("nvi-admin"),
    MANAGE_NVI_CANDIDATES("nvi-candidates"),
    MANAGE_ALL_PROJECTS("manage-projects"),
    MANAGE_DOI_AGENT("doi-agent"),
    SUPPORT("support"),
    MANAGE_KBS("kbs"),
    MANAGE_RESOURCE_FILES("resource-files"),
    MANAGE_CHANNEL_CLAIMS("channel-claims"),
    ACT_AS("act-as"),
    MANAGE_EXTERNAL_CLIENTS("external-clients");

    private static final Map<String, AccessRight> LOOKUP;
    private final String persistedValue;

    private String getPersistedValue() {
        return this.persistedValue;
    }

    private AccessRight(String persistedValue) {
        this.persistedValue = persistedValue;
    }

    public String toPersistedString() {
        return this.persistedValue;
    }

    public static AccessRight fromPersistedString(String accessRight) {
        return AccessRight.fromPersistedStringOptional(accessRight).orElseThrow(() -> new InvalidAccessRightException(accessRight));
    }

    public static Optional<AccessRight> fromPersistedStringOptional(String accessRight) {
        return Optional.ofNullable(LOOKUP.get(accessRight));
    }

    static {
        LOOKUP = Maps.uniqueIndex(Arrays.asList(AccessRight.values()), AccessRight::getPersistedValue);
    }
}

