/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.apigateway;

import com.amazonaws.services.lambda.runtime.Context;
import java.time.Duration;
import java.util.Map;
import nva.commons.apigateway.ApiGatewayHandler;
import nva.commons.apigateway.RequestInfo;
import nva.commons.apigateway.exceptions.ApiGatewayException;
import nva.commons.apigateway.exceptions.BadRequestException;
import nva.commons.core.Environment;
import nva.commons.core.JacocoGenerated;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;

public abstract class ApiS3PresignerGatewayHandler<I>
extends ApiGatewayHandler<I, Void> {
    public static final String LOCATION = "Location";
    private final S3Presigner s3presigner;

    @JacocoGenerated
    public ApiS3PresignerGatewayHandler(Class<I> iclass, S3Presigner s3Presigner, Environment environment) {
        super(iclass, environment);
        this.s3presigner = s3Presigner;
    }

    @JacocoGenerated
    public static S3Presigner defaultS3Presigner() {
        return S3Presigner.builder().region(Region.of((String)new Environment().readEnv("AWS_REGION"))).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create()).build();
    }

    @Override
    protected Void processInput(I input, RequestInfo requestInfo, Context context) throws ApiGatewayException {
        String filename = context.getAwsRequestId();
        this.generateAndWriteDataToS3(filename, input, requestInfo, context);
        PresignedGetObjectRequest preSignedUrl = this.presignS3Object(filename);
        this.setLocationHeader(preSignedUrl.url().toString());
        return null;
    }

    @Override
    @JacocoGenerated
    protected Integer getSuccessStatusCode(I input, Void output) {
        return 302;
    }

    protected abstract void generateAndWriteDataToS3(String var1, I var2, RequestInfo var3, Context var4) throws BadRequestException;

    protected abstract String getBucketName();

    protected abstract Duration getSignDuration();

    protected void setLocationHeader(String uri) {
        this.addAdditionalHeaders(() -> Map.of(LOCATION, uri));
    }

    protected PresignedGetObjectRequest presignS3Object(String filename) {
        GetObjectPresignRequest presignRequest = this.createPresignRequest(filename);
        return this.s3presigner.presignGetObject(presignRequest);
    }

    protected GetObjectRequest buildRequest(String filename) {
        return (GetObjectRequest)GetObjectRequest.builder().bucket(this.getBucketName()).key(filename).build();
    }

    protected GetObjectPresignRequest createPresignRequest(String filename) {
        return GetObjectPresignRequest.builder().signatureDuration(this.getSignDuration()).getObjectRequest(this.buildRequest(filename)).build();
    }
}

