/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.apigateway.exceptions;

import com.google.common.net.MediaType;
import java.util.List;
import java.util.stream.Collectors;
import nva.commons.apigateway.exceptions.ApiGatewayException;

public class UnsupportedAcceptHeaderException
extends ApiGatewayException {
    public static final String UNSUPPORTED_ACCEPT_HEADER_VALUE = "%s contains no supported Accept header values. Supported values are: %s";
    public static final String JOINING_DELIMITER = ", ";

    public UnsupportedAcceptHeaderException(List<MediaType> acceptMediaTypes, List<MediaType> supportedMediaTypes) {
        super(UnsupportedAcceptHeaderException.createMessage(acceptMediaTypes, supportedMediaTypes));
    }

    public static String createMessage(List<MediaType> acceptMediaTypes, List<MediaType> supportedMediaTypes) {
        String acceptMediaTypesCsv = acceptMediaTypes.stream().map(MediaType::toString).collect(Collectors.joining(JOINING_DELIMITER));
        String supportedMediaTypesCsv = supportedMediaTypes.stream().map(MediaType::toString).collect(Collectors.joining(JOINING_DELIMITER));
        return String.format(UNSUPPORTED_ACCEPT_HEADER_VALUE, acceptMediaTypesCsv, supportedMediaTypesCsv);
    }

    @Override
    protected Integer statusCode() {
        return 415;
    }
}

