/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Objects;
import java.util.Set;
import no.unit.nva.auth.JsonConfig;
import nva.commons.core.JacocoGenerated;

public class CognitoUserInfo {
    public static final String ELEMENTS_DELIMITER = ",";
    public static final String EMPTY_STRING = "";
    public static final String FEIDE_ID_CLAIM = "custom:feideId";
    public static final String SELECTED_CUSTOMER_CLAIM = "custom:customerId";
    public static final String ACCESS_RIGHTS_CLAIM = "custom:accessRights";
    public static final String NVA_USERNAME_CLAIM = "custom:nvaUsername";
    public static final String TOP_LEVEL_ORG_CRISTIN_ID_CLAIM = "custom:topOrgCristinId";
    public static final String PERSON_CRISTIN_ID_CLAIM = "custom:cristinId";
    @JsonProperty(value="custom:feideId")
    private String feideId;
    @JsonProperty(value="custom:customerId")
    private URI currentCustomer;
    @JsonProperty(value="custom:accessRights")
    private String accessRights;
    @JsonProperty(value="custom:nvaUsername")
    private String nvaUsername;
    @JsonProperty(value="custom:topOrgCristinId")
    private URI topOrgCristinId;
    @JsonProperty(value="custom:cristinId")
    private URI personCristinId;

    public static Builder builder() {
        return new Builder();
    }

    public static CognitoUserInfo fromString(String json) {
        return JsonConfig.beanFrom(CognitoUserInfo.class, json);
    }

    public URI getTopOrgCristinId() {
        return this.topOrgCristinId;
    }

    public String getNvaUsername() {
        return this.nvaUsername;
    }

    public void setNvaUsername(String nvaUsername) {
        this.nvaUsername = nvaUsername;
    }

    public URI getCurrentCustomer() {
        return this.currentCustomer;
    }

    public void setCurrentCustomer(URI currentCustomer) {
        this.currentCustomer = currentCustomer;
    }

    public String getFeideId() {
        return this.feideId;
    }

    public void setFeideId(String feideId) {
        this.feideId = feideId;
    }

    public String getAccessRights() {
        return Objects.nonNull(this.accessRights) ? this.accessRights : EMPTY_STRING;
    }

    public void setAccessRights(String accessRights) {
        this.accessRights = accessRights;
    }

    private void setTopOrgCristinId(URI topOrgCristinId) {
        this.topOrgCristinId = topOrgCristinId;
    }

    public URI getPersonCristinId() {
        return this.personCristinId;
    }

    public void setPersonCristinId(URI personCristinId) {
        this.personCristinId = personCristinId;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getFeideId(), this.getCurrentCustomer(), this.getAccessRights(), this.getNvaUsername(), this.getTopOrgCristinId(), this.getPersonCristinId());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CognitoUserInfo)) {
            return false;
        }
        CognitoUserInfo that = (CognitoUserInfo)o;
        return Objects.equals(this.getFeideId(), that.getFeideId()) && Objects.equals(this.getCurrentCustomer(), that.getCurrentCustomer()) && Objects.equals(this.getAccessRights(), that.getAccessRights()) && Objects.equals(this.getNvaUsername(), that.getNvaUsername()) && Objects.equals(this.getTopOrgCristinId(), that.getTopOrgCristinId()) && Objects.equals(this.getPersonCristinId(), that.getPersonCristinId());
    }

    public static final class Builder {
        private final CognitoUserInfo cognitoUserInfo = new CognitoUserInfo();

        private Builder() {
        }

        public Builder withFeideId(String feideId) {
            this.cognitoUserInfo.setFeideId(feideId);
            return this;
        }

        public Builder withCurrentCustomer(URI currentCustomer) {
            this.cognitoUserInfo.setCurrentCustomer(currentCustomer);
            return this;
        }

        public CognitoUserInfo build() {
            return this.cognitoUserInfo;
        }

        public Builder withAccessRights(Set<String> accessRights) {
            if (Objects.nonNull(accessRights)) {
                this.cognitoUserInfo.setAccessRights(String.join((CharSequence)CognitoUserInfo.ELEMENTS_DELIMITER, accessRights));
            }
            return this;
        }

        public Builder withNvaUsername(String nvaUsername) {
            this.cognitoUserInfo.setNvaUsername(nvaUsername);
            return this;
        }

        public Builder withTopOrgCristinId(URI topOrgCristinId) {
            this.cognitoUserInfo.setTopOrgCristinId(topOrgCristinId);
            return this;
        }

        public Builder withPersonCristinId(URI personCristinId) {
            this.cognitoUserInfo.setPersonCristinId(personCristinId);
            return this;
        }
    }
}

