/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.auth;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Objects;
import java.util.Set;
import no.unit.nva.auth.JsonConfig;
import nva.commons.core.JacocoGenerated;

public class CognitoUserInfo {
    public static final String ELEMENTS_DELIMITER = ",";
    public static final String EMPTY_STRING = "";
    public static final String PERSON_FEIDE_ID_CLAIM = "custom:feideId";
    public static final String SELECTED_CUSTOMER_CLAIM = "custom:customerId";
    public static final String ACCESS_RIGHTS_CLAIM = "custom:accessRights";
    public static final String USER_NAME_CLAIM = "custom:nvaUsername";
    public static final String TOP_LEVEL_ORG_CRISTIN_ID_CLAIM = "custom:topOrgCristinId";
    public static final String PERSON_CRISTIN_ID_CLAIM = "custom:cristinId";
    public static final String PERSON_NIN_CLAIM = "custom:nin";
    public static final String PERSON_FEIDE_NIN_CLAIM = "custom:feideIdNin";
    public static final String ROLES = "custom:roles";
    public static final String SUB = "sub";
    public static final String PERSON_AFFILIATION_CLAIM = "custom:personAffiliation";
    public static final String ALLOWED_CUSTOMERS = "custom:allowedCustomers";
    public static final String COGNITO_USER_NAME = "username";
    @JsonProperty(value="custom:feideId")
    private String feideId;
    @JsonProperty(value="custom:customerId")
    private URI currentCustomer;
    @JsonProperty(value="custom:accessRights")
    private String accessRights;
    @JsonProperty(value="custom:nvaUsername")
    private String userName;
    @JsonProperty(value="custom:topOrgCristinId")
    private URI topOrgCristinId;
    @JsonProperty(value="custom:cristinId")
    private URI personCristinId;
    @JsonAlias(value={"custom:feideIdNin"})
    @JsonProperty(value="custom:nin")
    private String personNin;
    @JsonProperty(value="custom:roles")
    private String roles;
    @JsonProperty(value="sub")
    private String sub;
    @JsonProperty(value="custom:personAffiliation")
    private URI personAffiliation;
    @JsonProperty(value="custom:allowedCustomers")
    private String allowedCustomers;
    @JsonProperty(value="username")
    private String cognitoUsername;

    public static Builder builder() {
        return new Builder();
    }

    public static CognitoUserInfo fromString(String json) {
        return JsonConfig.beanFrom(CognitoUserInfo.class, json);
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public URI getPersonAffiliation() {
        return this.personAffiliation;
    }

    public void setPersonAffiliation(URI personAffiliation) {
        this.personAffiliation = personAffiliation;
    }

    public String getAllowedCustomers() {
        return this.allowedCustomers;
    }

    public void setAllowedCustomers(String allowedCustomers) {
        this.allowedCustomers = allowedCustomers;
    }

    public String getCognitoUsername() {
        return this.cognitoUsername;
    }

    public void setCognitoUsername(String cognitoUsername) {
        this.cognitoUsername = cognitoUsername;
    }

    public URI getTopOrgCristinId() {
        return this.topOrgCristinId;
    }

    public void setTopOrgCristinId(URI topOrgCristinId) {
        this.topOrgCristinId = topOrgCristinId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public URI getCurrentCustomer() {
        return this.currentCustomer;
    }

    public void setCurrentCustomer(URI currentCustomer) {
        this.currentCustomer = currentCustomer;
    }

    public String getFeideId() {
        return this.feideId;
    }

    public void setFeideId(String feideId) {
        this.feideId = feideId;
    }

    public String getAccessRights() {
        return Objects.nonNull(this.accessRights) ? this.accessRights : EMPTY_STRING;
    }

    public void setAccessRights(String accessRights) {
        this.accessRights = accessRights;
    }

    public URI getPersonCristinId() {
        return this.personCristinId;
    }

    public void setPersonCristinId(URI personCristinId) {
        this.personCristinId = personCristinId;
    }

    public String getPersonNin() {
        return this.personNin;
    }

    public void setPersonNin(String personNin) {
        this.personNin = personNin;
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getFeideId(), this.getCurrentCustomer(), this.getAccessRights(), this.getUserName(), this.getTopOrgCristinId(), this.getPersonCristinId(), this.getPersonAffiliation(), this.getPersonNin());
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CognitoUserInfo)) {
            return false;
        }
        CognitoUserInfo that = (CognitoUserInfo)o;
        return Objects.equals(this.getFeideId(), that.getFeideId()) && Objects.equals(this.getCurrentCustomer(), that.getCurrentCustomer()) && Objects.equals(this.getAccessRights(), that.getAccessRights()) && Objects.equals(this.getUserName(), that.getUserName()) && Objects.equals(this.getTopOrgCristinId(), that.getTopOrgCristinId()) && Objects.equals(this.getPersonCristinId(), that.getPersonCristinId()) && Objects.equals(this.getPersonAffiliation(), that.getPersonAffiliation()) && Objects.equals(this.getPersonNin(), that.getPersonNin()) && Objects.equals(this.getFeideId(), that.getFeideId());
    }

    public static final class Builder {
        private final CognitoUserInfo cognitoUserInfo = new CognitoUserInfo();

        private Builder() {
        }

        public Builder withFeideId(String feideId) {
            this.cognitoUserInfo.setFeideId(feideId);
            return this;
        }

        public Builder withCurrentCustomer(URI currentCustomer) {
            this.cognitoUserInfo.setCurrentCustomer(currentCustomer);
            return this;
        }

        public Builder withAccessRights(Set<String> accessRights) {
            if (Objects.nonNull(accessRights)) {
                this.cognitoUserInfo.setAccessRights(String.join((CharSequence)CognitoUserInfo.ELEMENTS_DELIMITER, accessRights));
            }
            return this;
        }

        public Builder withUserName(String userName) {
            this.cognitoUserInfo.setUserName(userName);
            return this;
        }

        public Builder withTopOrgCristinId(URI topOrgCristinId) {
            this.cognitoUserInfo.setTopOrgCristinId(topOrgCristinId);
            return this;
        }

        public Builder withPersonCristinId(URI personCristinId) {
            this.cognitoUserInfo.setPersonCristinId(personCristinId);
            return this;
        }

        public Builder withPersonNin(String personNin) {
            this.cognitoUserInfo.setPersonNin(personNin);
            return this;
        }

        public Builder withRoles(String roles) {
            this.cognitoUserInfo.setRoles(roles);
            return this;
        }

        public Builder withSub(String sub) {
            this.cognitoUserInfo.setSub(sub);
            return this;
        }

        public Builder withPersonAffiliation(URI personAffiliation) {
            this.cognitoUserInfo.setPersonAffiliation(personAffiliation);
            return this;
        }

        public Builder withAllowedCustomers(String allowedCustomers) {
            this.cognitoUserInfo.setAllowedCustomers(allowedCustomers);
            return this;
        }

        public Builder withCognitoUsername(String cognitoUsername) {
            this.cognitoUserInfo.setCognitoUsername(cognitoUsername);
            return this;
        }

        public CognitoUserInfo build() {
            return this.cognitoUserInfo;
        }
    }
}

