/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.auth;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import no.unit.nva.auth.CognitoCredentials;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;
import nva.commons.core.paths.UriWrapper;

public class AuthorizedBackendClient {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String JWT_TOKEN_FIELD = "access_token";
    public static final Map<String, String> GRANT_TYPE_CLIENT_CREDENTIALS = Map.of("grant_type", "client_credentials");
    private final HttpClient httpClient;
    private final CognitoCredentials cognitoCredentials;
    private final boolean bearerTokenIsNotInjectedDirectly;
    private String bearerToken;

    protected AuthorizedBackendClient(HttpClient httpClient, String bearerToken, CognitoCredentials cognitoCredentials) {
        this.httpClient = httpClient;
        this.bearerToken = bearerToken;
        this.cognitoCredentials = cognitoCredentials;
        this.bearerTokenIsNotInjectedDirectly = Objects.isNull(bearerToken);
    }

    @JacocoGenerated
    public static AuthorizedBackendClient prepareWithCognitoCredentials(CognitoCredentials cognitoCredentials) {
        return AuthorizedBackendClient.prepareWithCognitoCredentials(HttpClient.newHttpClient(), cognitoCredentials);
    }

    public static AuthorizedBackendClient prepareWithCognitoCredentials(HttpClient httpClient, CognitoCredentials cognitoApiClientCredentials) {
        return new AuthorizedBackendClient(httpClient, null, cognitoApiClientCredentials);
    }

    @JacocoGenerated
    public static AuthorizedBackendClient prepareWithBearerToken(String bearerToken) {
        return AuthorizedBackendClient.prepareWithBearerToken(HttpClient.newHttpClient(), bearerToken);
    }

    public static AuthorizedBackendClient prepareWithBearerToken(HttpClient httpClient, String bearerToken) {
        return new AuthorizedBackendClient(httpClient, bearerToken, null);
    }

    @JacocoGenerated
    public static AuthorizedBackendClient prepareWithBearerTokenAndCredentials(HttpClient httpClient, String bearerToken, CognitoCredentials cognitoCredentials) {
        return new AuthorizedBackendClient(httpClient, bearerToken, cognitoCredentials);
    }

    @JacocoGenerated
    protected String getBearerToken() {
        return this.bearerToken;
    }

    public <T> HttpResponse<T> send(HttpRequest.Builder request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        this.refreshToken();
        HttpRequest authorizedRequest = request.setHeader(AUTHORIZATION_HEADER, this.bearerToken).build();
        return this.httpClient.send(authorizedRequest, responseBodyHandler);
    }

    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest.Builder request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        this.refreshToken();
        HttpRequest authorizedRequest = request.setHeader(AUTHORIZATION_HEADER, this.bearerToken).build();
        return this.httpClient.sendAsync(authorizedRequest, responseBodyHandler);
    }

    private static URI standardOauth2TokenEndpoint(URI cognitoHost) {
        return UriWrapper.fromUri((URI)cognitoHost).addChild(new String[]{"oauth2"}).addChild(new String[]{"token"}).getUri();
    }

    private static HttpRequest.BodyPublisher clientCredentialsAuthType() {
        String queryParameters = UriWrapper.fromHost((String)"notimportant").addQueryParameters(GRANT_TYPE_CLIENT_CREDENTIALS).getUri().getRawQuery();
        return HttpRequest.BodyPublishers.ofString(queryParameters);
    }

    private String formatBasicAuthenticationHeader() {
        return (String)Try.attempt(this::formatAuthenticationHeaderValue).map(str -> Base64.getEncoder().encodeToString(str.getBytes(StandardCharsets.UTF_8))).map(credentials -> "Basic " + credentials).orElseThrow();
    }

    private String formatAuthenticationHeaderValue() {
        return String.format("%s:%s", this.cognitoCredentials.getCognitoAppClientId(), this.cognitoCredentials.getCognitoAppClientSecret());
    }

    private void refreshToken() {
        if (this.bearerTokenIsNotInjectedDirectly) {
            URI tokenUri = AuthorizedBackendClient.standardOauth2TokenEndpoint(this.cognitoCredentials.getCognitoOAuthServerUri());
            HttpRequest request = this.formatRequestForJwtToken(tokenUri);
            this.bearerToken = this.sendRequestAndExtractToken(request);
        }
    }

    private String createBearerToken(String accessToken) {
        return "Bearer " + accessToken;
    }

    private String sendRequestAndExtractToken(HttpRequest request) {
        return (String)Try.attempt(() -> this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8))).map(HttpResponse::body).map(arg_0 -> ((JSON)JSON.std).mapFrom(arg_0)).map(json -> json.get(JWT_TOKEN_FIELD)).map(Objects::toString).map(this::createBearerToken).orElseThrow();
    }

    private HttpRequest formatRequestForJwtToken(URI tokenUri) {
        return HttpRequest.newBuilder(tokenUri).setHeader(AUTHORIZATION_HEADER, this.formatBasicAuthenticationHeader()).setHeader(CONTENT_TYPE, APPLICATION_X_WWW_FORM_URLENCODED).POST(AuthorizedBackendClient.clientCredentialsAuthType()).build();
    }
}

