/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.auth.uriretriever;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import no.unit.nva.auth.AuthorizedBackendClient;
import no.unit.nva.auth.CognitoCredentials;
import no.unit.nva.auth.uriretriever.BackendClientCredentials;
import no.unit.nva.auth.uriretriever.RawContentRetriever;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;
import nva.commons.core.paths.UriWrapper;
import nva.commons.secrets.SecretsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;

@JacocoGenerated
public class AuthorizedBackendUriRetriever
implements RawContentRetriever {
    public static final String FAILED_TO_RETRIEVE_URI = "Failed to retrieve uri {}";
    public static final String API_RESPONDED_WITH_ERROR_CODE = "Api responded with: ";
    public static final String ACCEPT = "Accept";
    private static final Logger logger = LoggerFactory.getLogger(AuthorizedBackendUriRetriever.class);
    private final HttpClient httpClient;
    private final SecretsReader secretsReader;
    private final String backendClientAuthUrl;
    private final String backendClientSecretName;

    public AuthorizedBackendUriRetriever(HttpClient httpClient, SecretsManagerClient secretsManagerClient, String backendClientAuthUrl, String backendClientSecretName) {
        this.httpClient = httpClient;
        this.secretsReader = new SecretsReader(secretsManagerClient);
        this.backendClientAuthUrl = backendClientAuthUrl;
        this.backendClientSecretName = backendClientSecretName;
    }

    @JacocoGenerated
    public AuthorizedBackendUriRetriever(String backendClientAuthUrl, String backendClientSecretName) {
        this(HttpClient.newHttpClient(), SecretsReader.defaultSecretsManagerClient(), backendClientAuthUrl, backendClientSecretName);
    }

    @Override
    public Optional<String> getRawContent(URI uri, String mediaType) {
        return Try.attempt(this::getAuthorizedBackendClient).map(authorizedBackendClient -> this.getHttpResponse((AuthorizedBackendClient)authorizedBackendClient, uri, mediaType)).map(this::getRawContentFromHttpResponse).toOptional();
    }

    @Override
    public Optional<HttpResponse<String>> fetchResponse(URI uri, String mediaType) {
        return Try.attempt(this::getAuthorizedBackendClient).map(authorizedBackendClient -> this.getHttpResponse((AuthorizedBackendClient)authorizedBackendClient, uri, mediaType)).toOptional();
    }

    private URI getCognitoTokenUrl() {
        return UriWrapper.fromHost((String)this.backendClientAuthUrl).getUri();
    }

    private String getRawContentFromHttpResponse(HttpResponse<String> response) {
        if (response.statusCode() != 200) {
            logger.error(FAILED_TO_RETRIEVE_URI, response);
            throw new RuntimeException(API_RESPONDED_WITH_ERROR_CODE + response.statusCode());
        }
        return response.body();
    }

    private CognitoCredentials fetchCredentials() {
        BackendClientCredentials credentials = (BackendClientCredentials)this.secretsReader.fetchClassSecret(this.backendClientSecretName, BackendClientCredentials.class);
        URI uri = this.getCognitoTokenUrl();
        return new CognitoCredentials(credentials::getId, credentials::getSecret, uri);
    }

    private AuthorizedBackendClient getAuthorizedBackendClient() {
        return AuthorizedBackendClient.prepareWithCognitoCredentials(this.httpClient, this.fetchCredentials());
    }

    private HttpResponse<String> getHttpResponse(AuthorizedBackendClient backendClient, URI customerId, String mediaType) throws IOException, InterruptedException {
        HttpRequest.Builder request = HttpRequest.newBuilder(customerId).headers(ACCEPT, mediaType).GET();
        return backendClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
    }
}

