/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import no.unit.nva.auth.CognitoCredentials;
import no.unit.nva.auth.UnexpectedHttpResponseException;
import nva.commons.core.attempt.Try;
import nva.commons.core.paths.UriWrapper;

public class CognitoAuthenticator {
    public static final String OAUTH2_PATH_SEGMENT = "oauth2";
    public static final String TOKEN_PATH_SEGMENT = "token";
    public static final String BASIC_AUTH_CREDENTIALS_TEMPLATE = "%s:%s";
    public static final String BASIC_AUTH_HEADER_TEMPLATE = "%s %s";
    public static final String GRANT_TYPE_CLIENT_CREDENTIALS = "grant_type=client_credentials";
    public static final String JWT_TOKEN_FIELD = "access_token";
    private final CognitoCredentials credentials;
    private final HttpClient httpClient;

    public CognitoAuthenticator(HttpClient httpClient, CognitoCredentials credentials) {
        this.httpClient = httpClient;
        this.credentials = credentials;
    }

    public DecodedJWT fetchBearerToken() {
        HttpResponse<String> tokenResponse = this.fetchTokenResponse();
        return (DecodedJWT)Try.attempt(() -> tokenResponse).map(HttpResponse::body).map(arg_0 -> ((JSON)JSON.std).mapFrom(arg_0)).map(json -> json.get(JWT_TOKEN_FIELD)).map(this::assertFieldIsPresent).map(Objects::toString).map(JWT::decode).orElseThrow();
    }

    private static URI standardOauth2TokenEndpoint(URI cognitoHost) {
        return UriWrapper.fromUri((URI)cognitoHost).addChild(new String[]{OAUTH2_PATH_SEGMENT}).addChild(new String[]{TOKEN_PATH_SEGMENT}).getUri();
    }

    private static HttpRequest.BodyPublisher clientCredentialsAuthType() {
        return HttpRequest.BodyPublishers.ofString(GRANT_TYPE_CLIENT_CREDENTIALS);
    }

    private Object assertFieldIsPresent(Object object) {
        if (Objects.isNull(object)) {
            throw new IllegalStateException("Received token response without token");
        }
        return object;
    }

    private String formatAuthenticationHeaderValue() {
        return String.format(BASIC_AUTH_CREDENTIALS_TEMPLATE, this.credentials.getCognitoAppClientId(), this.credentials.getCognitoAppClientSecret());
    }

    private String formatBasicAuthenticationHeader() {
        return (String)Try.attempt(this::formatAuthenticationHeaderValue).map(str -> Base64.getEncoder().encodeToString(str.getBytes(StandardCharsets.UTF_8))).map(credentials -> String.format(BASIC_AUTH_HEADER_TEMPLATE, "Basic", credentials)).orElseThrow();
    }

    private HttpRequest createTokenRequest() {
        URI tokenUri = CognitoAuthenticator.standardOauth2TokenEndpoint(this.credentials.getCognitoOAuthServerUri());
        return this.formatRequestForJwtToken(tokenUri);
    }

    private HttpResponse<String> fetchTokenResponse() {
        return (HttpResponse)Try.attempt(this::sendTokenRequest).map(this::responseIsSuccessful).orElseThrow();
    }

    private HttpResponse<String> sendTokenRequest() throws IOException, InterruptedException {
        return this.httpClient.send(this.createTokenRequest(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
    }

    private HttpResponse<String> responseIsSuccessful(HttpResponse<String> response) {
        if (200 != response.statusCode()) {
            throw UnexpectedHttpResponseException.fromHttpResponse(response);
        }
        return response;
    }

    private HttpRequest formatRequestForJwtToken(URI tokenUri) {
        return HttpRequest.newBuilder(tokenUri).setHeader("Authorization", this.formatBasicAuthenticationHeader()).setHeader("Content-Type", "application/x-www-form-urlencoded").POST(CognitoAuthenticator.clientCredentialsAuthType()).build();
    }
}

