/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.auth.uriretriever;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import no.unit.nva.auth.uriretriever.RawContentRetriever;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;

@JacocoGenerated
public class UriRetriever
implements RawContentRetriever {
    public static final String ACCEPT = "Accept";
    private final HttpClient httpClient;

    public UriRetriever() {
        this.httpClient = UriRetriever.newHttpClient();
    }

    public UriRetriever(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Optional<String> getRawContent(URI uri, String mediaType) {
        return Try.attempt(() -> this.httpClient.send(this.createHttpRequest(uri, mediaType), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8))).map(HttpResponse::body).toOptional();
    }

    @Override
    public Optional<HttpResponse<String>> fetchResponse(URI uri, String mediaType) {
        return Try.attempt(() -> this.httpClient.send(this.createHttpRequest(uri, mediaType), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8))).toOptional();
    }

    private static HttpClient newHttpClient() {
        return HttpClient.newHttpClient();
    }

    private HttpRequest createHttpRequest(URI uri, String mediaType) {
        return HttpRequest.newBuilder().uri(uri).headers(ACCEPT, mediaType).GET().build();
    }
}

