/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.clients;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import no.unit.nva.auth.AuthorizedBackendClient;
import no.unit.nva.auth.CognitoCredentials;
import no.unit.nva.clients.BackendClientCredentials;
import no.unit.nva.clients.CustomerDto;
import no.unit.nva.clients.CustomerList;
import no.unit.nva.clients.GetExternalClientResponse;
import no.unit.nva.clients.UserDto;
import no.unit.nva.commons.json.JsonUtils;
import nva.commons.apigateway.exceptions.ApiGatewayException;
import nva.commons.apigateway.exceptions.NotFoundException;
import nva.commons.core.Environment;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Failure;
import nva.commons.core.attempt.Try;
import nva.commons.core.paths.UriWrapper;
import nva.commons.secrets.SecretsReader;

public class IdentityServiceClient {
    public static final String CREDENTIALS_SECRET_NAME = "BackendCognitoClientCredentials";
    public static final String API_PATH_USERS_AND_ROLES = "users-roles";
    public static final String API_PATH_EXTERNAL_CLIENTS = "external-clients";
    private static final String API_PATH_USERS = "users";
    private static final String AUTH_HOST = new Environment().readEnv("BACKEND_CLIENT_AUTH_URL");
    private static final String API_HOST = new Environment().readEnv("API_HOST");
    public static final String CUSTOMER_PATH_PARAM = "customer";
    public static final String CRISTIN_ID_PATH_PARAM = "cristinId";
    private final AuthorizedBackendClient authorizedClient;
    private final HttpClient unauthorizedClient;

    public IdentityServiceClient(HttpClient httpClient, String bearerToken, CognitoCredentials cognitoCredentials) {
        this.unauthorizedClient = httpClient;
        this.authorizedClient = AuthorizedBackendClient.prepareWithBearerTokenAndCredentials((HttpClient)httpClient, (String)bearerToken, (CognitoCredentials)cognitoCredentials);
    }

    @JacocoGenerated
    public static IdentityServiceClient prepare() {
        CognitoCredentials credentials = IdentityServiceClient.fetchCredentials();
        return new IdentityServiceClient(HttpClient.newBuilder().build(), null, credentials);
    }

    public GetExternalClientResponse getExternalClient(String clientId) throws NotFoundException {
        HttpRequest.Builder request = IdentityServiceClient.getRequestBuilderFromUri(this.constructExternalClientsGetPath(clientId));
        return (GetExternalClientResponse)Try.attempt(this.getHttpResponseCallable(request)).map(this::validateResponse).map(r -> this.mapResponse((Class)GetExternalClientResponse.class, (HttpResponse<String>)r)).orElseThrow(this::handleFailure);
    }

    public GetExternalClientResponse getExternalClientByToken(String bearerToken) throws NotFoundException {
        HttpRequest.Builder request = HttpRequest.newBuilder().GET().uri(this.constructExternalClientsUserinfoGetPath()).setHeader("Authorization", bearerToken);
        return (GetExternalClientResponse)Try.attempt(() -> this.unauthorizedClient.send(request.build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8))).map(this::validateResponse).map(r -> this.mapResponse((Class)GetExternalClientResponse.class, (HttpResponse<String>)r)).orElseThrow(this::handleFailure);
    }

    public UserDto getUser(String userName) throws NotFoundException {
        HttpRequest.Builder request = IdentityServiceClient.getRequestBuilderFromUri(this.constructUserGetPath(userName));
        return (UserDto)Try.attempt(this.getHttpResponseCallable(request)).map(this::validateResponse).map(r -> this.mapResponse((Class)UserDto.class, (HttpResponse<String>)r)).orElseThrow(this::handleFailure);
    }

    public CustomerDto getCustomerByCristinId(URI topLevelOrgCristinId) throws NotFoundException {
        HttpRequest.Builder request = IdentityServiceClient.getRequestBuilderFromUri(this.constructCustomerGetPath(topLevelOrgCristinId));
        return (CustomerDto)Try.attempt(this.getHttpResponseCallable(request)).map(this::validateResponse).map(r -> this.mapResponse((Class)CustomerDto.class, (HttpResponse<String>)r)).orElseThrow(this::handleFailure);
    }

    public CustomerDto getCustomerById(URI customerId) throws NotFoundException {
        HttpRequest.Builder request = IdentityServiceClient.getRequestBuilderFromUri(customerId);
        return (CustomerDto)Try.attempt(this.getHttpResponseCallable(request)).map(this::validateResponse).map(r -> this.mapResponse((Class)CustomerDto.class, (HttpResponse<String>)r)).orElseThrow(this::handleFailure);
    }

    private static HttpRequest.Builder getRequestBuilderFromUri(URI customerId) {
        return HttpRequest.newBuilder().GET().uri(customerId);
    }

    public CustomerList getAllCustomers() throws ApiGatewayException {
        HttpRequest.Builder request = IdentityServiceClient.getRequestBuilderFromUri(this.constructListCustomerUri());
        return (CustomerList)Try.attempt(this.getHttpResponseCallable(request)).map(this::validateResponse).map(HttpResponse::body).map(value -> (CustomerList)JsonUtils.dtoObjectMapper.readValue(value, CustomerList.class)).orElseThrow(this::handleFailure);
    }

    private URI constructListCustomerUri() {
        return UriWrapper.fromHost((String)API_HOST).addChild(new String[]{CUSTOMER_PATH_PARAM}).getUri();
    }

    private URI constructCustomerGetPath(URI topLevelOrgCristinId) {
        URI customerByCristinIdUri = UriWrapper.fromHost((String)API_HOST).addChild(new String[]{CUSTOMER_PATH_PARAM}).addChild(new String[]{CRISTIN_ID_PATH_PARAM}).getUri();
        return URI.create(String.valueOf(customerByCristinIdUri) + "/" + URLEncoder.encode(topLevelOrgCristinId.toString(), StandardCharsets.UTF_8));
    }

    @JacocoGenerated
    private static CognitoCredentials fetchCredentials() {
        SecretsReader secretsReader = new SecretsReader(SecretsReader.defaultSecretsManagerClient());
        BackendClientCredentials credentials = (BackendClientCredentials)secretsReader.fetchClassSecret(CREDENTIALS_SECRET_NAME, BackendClientCredentials.class);
        URI uri = UriWrapper.fromHost((String)AUTH_HOST).getUri();
        return new CognitoCredentials(credentials::getId, credentials::getSecret, uri);
    }

    private UriWrapper usersAndRolesURI() {
        return UriWrapper.fromHost((String)API_HOST).addChild(new String[]{API_PATH_USERS_AND_ROLES});
    }

    private URI constructExternalClientsGetPath(String clientId) {
        return this.usersAndRolesURI().addChild(new String[]{API_PATH_EXTERNAL_CLIENTS}).addChild(new String[]{clientId}).getUri();
    }

    private URI constructUserGetPath(String userName) {
        return this.usersAndRolesURI().addChild(new String[]{API_PATH_USERS}).addChild(new String[]{userName}).getUri();
    }

    private URI constructExternalClientsUserinfoGetPath() {
        return this.usersAndRolesURI().addChild(new String[]{API_PATH_EXTERNAL_CLIENTS}).getUri();
    }

    private <T> T mapResponse(Class<T> clazz, HttpResponse<String> response) throws JsonProcessingException {
        return (T)JsonUtils.dtoObjectMapper.readValue(response.body(), clazz);
    }

    private NotFoundException handleFailure(Failure<?> responseFailure) {
        Exception exception = responseFailure.getException();
        if (exception instanceof NotFoundException) {
            return new NotFoundException(exception);
        }
        throw new RuntimeException();
    }

    private <S> HttpResponse<String> validateResponse(HttpResponse<String> response) throws NotFoundException {
        if (response.statusCode() == 404) {
            throw new NotFoundException("Client not found");
        }
        if (response.statusCode() != 200) {
            throw new IllegalStateException("Received " + response.statusCode() + " from identity service");
        }
        return response;
    }

    private Callable<HttpResponse<String>> getHttpResponseCallable(HttpRequest.Builder request) {
        return () -> this.authorizedClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
    }
}

