/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.clients;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.List;
import no.unit.nva.commons.json.JsonSerializable;

public record UserDto(@JsonProperty(value="username") String username, @JsonProperty(value="institution") URI institution, @JsonProperty(value="givenName") String givenName, @JsonProperty(value="familyName") String familyName, @JsonProperty(value="viewingScope") ViewingScope viewingScope, @JsonProperty(value="roles") List<Role> roles, @JsonProperty(value="cristinId") URI cristinId, @JsonProperty(value="feideIdentifier") String feideIdentifier, @JsonProperty(value="institutionCristinId") URI institutionCristinId, @JsonProperty(value="affiliation") URI affiliation, @JsonProperty(value="type") String type, @JsonProperty(value="accessRights") List<String> accessRights) implements JsonSerializable
{
    public static Builder builder() {
        return new Builder();
    }

    public record ViewingScope(@JsonProperty(value="type") String type, @JsonProperty(value="includedUnits") List<URI> includedUnits, List<URI> excludedUnits) {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String type;
            private List<URI> includedUnits;
            private List<URI> excludedUnits;

            private Builder() {
            }

            public Builder withType(String type) {
                this.type = type;
                return this;
            }

            public Builder withIncludedUnits(List<URI> includedUnits) {
                this.includedUnits = includedUnits;
                return this;
            }

            public Builder withExcludedUnits(List<URI> excludedUnits) {
                this.excludedUnits = excludedUnits;
                return this;
            }

            public ViewingScope build() {
                return new ViewingScope(this.type, this.includedUnits, this.excludedUnits);
            }
        }
    }

    public static final class Builder {
        private String username;
        private URI institution;
        private String givenName;
        private String familyName;
        private ViewingScope viewingScope;
        private List<Role> roles;
        private URI cristinId;
        private String feideIdentifier;
        private URI institutionCristinId;
        private URI affiliation;
        private String type;
        private List<String> accessRights;

        private Builder() {
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withInstitution(URI institution) {
            this.institution = institution;
            return this;
        }

        public Builder withGivenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder withFamilyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder withViewingScope(ViewingScope viewingScope) {
            this.viewingScope = viewingScope;
            return this;
        }

        public Builder withRoles(List<Role> roles) {
            this.roles = roles;
            return this;
        }

        public Builder withCristinId(URI cristinId) {
            this.cristinId = cristinId;
            return this;
        }

        public Builder withFeideIdentifier(String feideIdentifier) {
            this.feideIdentifier = feideIdentifier;
            return this;
        }

        public Builder withInstitutionCristinId(URI institutionCristinId) {
            this.institutionCristinId = institutionCristinId;
            return this;
        }

        public Builder withAffiliation(URI affiliation) {
            this.affiliation = affiliation;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withAccessRights(List<String> accessRights) {
            this.accessRights = accessRights;
            return this;
        }

        public UserDto build() {
            return new UserDto(this.username, this.institution, this.givenName, this.familyName, this.viewingScope, this.roles, this.cristinId, this.feideIdentifier, this.institutionCristinId, this.affiliation, this.type, this.accessRights);
        }
    }

    public record Role(@JsonProperty(value="rolename") String rolename, @JsonProperty(value="accessRights") List<String> accessRights, @JsonProperty(value="type") String type) {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String rolename;
            private List<String> accessRights;
            private String type;

            private Builder() {
            }

            public Builder withRolename(String rolename) {
                this.rolename = rolename;
                return this;
            }

            public Builder withAccessRights(List<String> accessRights) {
                this.accessRights = accessRights;
                return this;
            }

            public Builder withType(String type) {
                this.type = type;
                return this;
            }

            public Role build() {
                return new Role(this.rolename, this.accessRights, this.type);
            }
        }
    }
}

