/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.clients.cristin;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.net.URI;
import java.util.Optional;
import java.util.Set;
import no.unit.nva.clients.cristin.Affiliation;
import no.unit.nva.clients.cristin.TypedValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonTypeName(value="Person")
public record CristinPersonDto(URI id, Set<TypedValue> identifiers, Set<TypedValue> names, Set<Affiliation> affiliations, boolean verified) {
    public static final String FIRST_NAME = "FirstName";
    public static final String LAST_NAME = "LastName";
    public static final String FULL_NAME_PATTERN = "%s %s";

    public Optional<String> firstName() {
        return this.names().stream().filter(CristinPersonDto::isFirstName).map(TypedValue::value).findFirst();
    }

    public Optional<String> lastName() {
        return this.names().stream().filter(CristinPersonDto::isLastName).map(TypedValue::value).findFirst();
    }

    public String fullName() {
        String firstName = this.firstName().orElse(null);
        String lastName = this.lastName().orElse(null);
        return FULL_NAME_PATTERN.formatted(firstName, lastName);
    }

    private static boolean isFirstName(TypedValue typedValue) {
        return FIRST_NAME.equals(typedValue.type());
    }

    private static boolean isLastName(TypedValue typedValue) {
        return LAST_NAME.equals(typedValue.type());
    }
}

