/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.clients.cristin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import no.unit.nva.commons.json.JsonSerializable;
import nva.commons.core.SingletonCollector;

public record CristinOrganizationDto(URI id, URI context, String type, List<CristinOrganizationDto> partOf, List<CristinOrganizationDto> hasPart, String country, Map<String, String> labels, String acronym) implements JsonSerializable
{
    @JsonIgnore
    public CristinOrganizationDto getTopLevelOrganization() {
        if (CristinOrganizationDto.hasPartOf(this)) {
            CristinOrganizationDto organization = (CristinOrganizationDto)this.partOf().stream().collect(SingletonCollector.collect());
            while (CristinOrganizationDto.hasPartOf(organization)) {
                organization = (CristinOrganizationDto)organization.partOf().stream().collect(SingletonCollector.collect());
            }
            return organization;
        }
        return this;
    }

    private static boolean hasPartOf(CristinOrganizationDto organization) {
        return Objects.nonNull(organization.partOf()) && !organization.partOf().isEmpty();
    }
}

