/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.clients.cristin;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import no.unit.nva.clients.cristin.CristinOrganizationDto;
import no.unit.nva.clients.cristin.CristinPersonDto;
import no.unit.nva.commons.json.JsonUtils;
import nva.commons.apigateway.exceptions.NotFoundException;
import nva.commons.core.Environment;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;
import nva.commons.core.paths.UriWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CristinClient {
    public static final String CRISTIN = "cristin";
    public static final String PERSON = "person";
    public static final String ORGANIZATION = "organization";
    private static final Logger LOGGER = LoggerFactory.getLogger(CristinClient.class);
    private static final String API_HOST = new Environment().readEnv("API_HOST");
    private final HttpClient httpClient;

    public CristinClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @JacocoGenerated
    public static CristinClient defaultClient() {
        return new CristinClient(HttpClient.newBuilder().build());
    }

    public Optional<CristinOrganizationDto> getOrganization(String identifier) {
        return this.getOrganization(CristinClient.createCristinOrganizationUri(identifier));
    }

    public Optional<CristinPersonDto> getPerson(String identifier) {
        return this.getPerson(CristinClient.createCristinPeronUri(identifier));
    }

    public Optional<CristinPersonDto> getPerson(URI uri) {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(uri).build();
        return Try.attempt(() -> this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8))).map(this::validateResponse).map(response -> this.mapResponse((Class)CristinPersonDto.class, (HttpResponse<String>)response)).toOptional();
    }

    public Optional<CristinOrganizationDto> getOrganization(URI uri) {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(uri).build();
        return Try.attempt(() -> this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8))).map(this::validateResponse).map(response -> this.mapResponse((Class)CristinOrganizationDto.class, (HttpResponse<String>)response)).toOptional();
    }

    private static URI createCristinPeronUri(String identifier) {
        return UriWrapper.fromHost((String)API_HOST).addChild(new String[]{CRISTIN}).addChild(new String[]{PERSON}).addChild(new String[]{identifier}).getUri();
    }

    private static URI createCristinOrganizationUri(String identifier) {
        return UriWrapper.fromHost((String)API_HOST).addChild(new String[]{CRISTIN}).addChild(new String[]{ORGANIZATION}).addChild(new String[]{identifier}).getUri();
    }

    private HttpResponse<String> validateResponse(HttpResponse<String> response) throws NotFoundException {
        URI requestUri = response.request().uri();
        if (response.statusCode() == 404) {
            LOGGER.error("Cristin responded with not found: {}", (Object)requestUri);
            throw new NotFoundException("Not found " + String.valueOf(requestUri));
        }
        if (response.statusCode() != 200) {
            LOGGER.error("Cristin responded with {} when fetching: {}", (Object)response.statusCode(), (Object)requestUri);
            throw new RuntimeException("Something went wrong fetching: " + String.valueOf(requestUri));
        }
        return response;
    }

    private <T> T mapResponse(Class<T> clazz, HttpResponse<String> response) throws JsonProcessingException {
        return (T)JsonUtils.dtoObjectMapper.readValue(response.body(), clazz);
    }
}

