/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.doi.models;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import no.unit.nva.doi.models.ImmutableDoi;

public abstract class Doi {
    public static final String HANDLE_DOI_PREFIX = "10.";
    public static final String ERROR_PROXY_URI_MUST_BE_A_VALID_URL = "Proxy URI must be a valid URL";
    public static final String DOI_URI_SYNTAX = "<hypertextTransferProtocol>://<proxy>/<prefix>/<suffix>";
    protected static final String DOI_ORG = "doi.org";
    protected static final String HANDLE_STAGE_DATACITE_ORG = "handle.stage.datacite.org";
    protected static final String DX_DOI_ORG = "dx.doi.org";
    public static final List<String> VALID_PROXIES = List.of("doi.org", "dx.doi.org", "handle.stage.datacite.org");
    protected static final String HTTPS = "https";
    protected static final String HTTP = "http";
    public static final List<String> VALID_SCHEMES = List.of("https", "http");
    protected static final char PATH_SEPARATOR = '/';
    protected static final String PATH_SEPARATOR_STRING = String.valueOf('/');
    protected static final String SCHEMA_SEPARATOR = "://";
    public static final URI DEFAULT_DOI_PROXY = URI.create("https".concat("://").concat("doi.org").concat(PATH_SEPARATOR_STRING));

    public static ImmutableDoi.Builder builder() {
        return ImmutableDoi.builder();
    }

    public abstract String getPrefix();

    public abstract String getSuffix();

    public URI getProxy() {
        return DEFAULT_DOI_PROXY;
    }

    public String toIdentifier() {
        return this.getPrefix() + "/" + this.getSuffix();
    }

    public URI toUri() {
        try {
            return this.createDoi();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(ERROR_PROXY_URI_MUST_BE_A_VALID_URL, e);
        }
    }

    protected URI createDoi() throws URISyntaxException {
        return new URI(this.getProxy().getScheme(), this.getProxy().getUserInfo(), this.getProxy().getHost(), this.getProxy().getPort(), "/" + this.toIdentifier(), null, null);
    }
}

