/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.doi;

import java.net.URL;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DoiValidator {
    public static final Pattern DOI_URL_PATTERN = Pattern.compile("^https?://(dx\\.)?doi\\.org/(10(?:\\.[0-9]+)+)/(.+)$", 2);
    public static final Pattern DOI_STRING_PATTERN = Pattern.compile("^(doi:)?(10(?:\\.[0-9]+)+)/(.+)$", 2);

    private DoiValidator() {
    }

    public static boolean validate(String doi) {
        if (Objects.isNull(doi)) {
            return false;
        }
        Matcher urlMatcher = DOI_URL_PATTERN.matcher(doi);
        Matcher stringMatcher = DOI_STRING_PATTERN.matcher(doi);
        return urlMatcher.find() || stringMatcher.find();
    }

    public static Boolean validate(URL doi) {
        if (Objects.isNull(doi)) {
            return false;
        }
        return DoiValidator.validate(doi.toString());
    }
}

