/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.doi.models;

import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import no.unit.nva.doi.models.Doi;

public final class ImmutableDoi
extends Doi {
    public static final String MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_PROXY = "proxy";
    public static final String MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_PREFIX = "prefix";
    public static final String MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_SUFFIX = "suffix";
    public static final String MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_IDENTIFIER = "identifier";
    public static final String MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_DOI = "doi";
    public static final String ERROR_DOI_URI_INVALID_FORMAT = "DOI does not look like a valid format following ".concat("<hypertextTransferProtocol>://<proxy>/<prefix>/<suffix>").concat(". It was: ");
    public static final String CANNOT_BUILD_DOI_PROXY_IS_NOT_A_VALID_PROXY = "Cannot build Doi, proxy is not a valid proxy.";
    public static final String CANNOT_BUILD_DOI_DOI_PREFIX_IS_NOT_VALID = "Cannot build Doi, prefix must start with ".concat("10.").concat(" and contain some repository id");
    public static final String BUILDER_OF_DOI_IS_STRICT_ATTRIBUTE_IS_ALREADY_SET = "Builder of Doi is strict, attribute is already set: ";
    private final URI proxy;
    private final String prefix;
    private final String suffix;

    private ImmutableDoi(Builder builder) {
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.proxy = builder.proxyIsSet() ? builder.proxy : Objects.requireNonNull(super.getProxy(), MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_PROXY);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public URI getProxy() {
        return this.proxy;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDoi && this.equalTo((ImmutableDoi)another);
    }

    public int hashCode() {
        return Objects.hash(this.proxy, this.prefix, this.suffix);
    }

    public String toString() {
        return this.getPrefix() + "/" + this.getSuffix();
    }

    private static URI createDoiUriWithoutIdentifier(URI value) {
        try {
            return new URI(value.getScheme(), value.getUserInfo(), value.getHost(), value.getPort(), PATH_SEPARATOR_STRING, null, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not reconstruct URI and strip path, query and fragment arguments");
        }
    }

    private boolean equalTo(ImmutableDoi another) {
        return this.proxy.equals(another.proxy) && this.prefix.equals(another.prefix) && this.suffix.equals(another.suffix);
    }

    public static final class Builder {
        private URI proxy;
        private String prefix;
        private String suffix;

        private Builder() {
        }

        public final Builder withProxy(URI proxy) {
            Builder.checkNotIsSet(this.proxyIsSet(), ImmutableDoi.MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_PROXY);
            this.proxy = Objects.requireNonNull(proxy, ImmutableDoi.MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_PROXY);
            return this;
        }

        public final Builder withPrefix(String prefix) {
            Builder.checkNotIsSet(this.prefixIsSet(), ImmutableDoi.MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_PREFIX);
            this.prefix = Objects.requireNonNull(prefix, ImmutableDoi.MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_PREFIX);
            return this;
        }

        public final Builder withSuffix(String suffix) {
            Builder.checkNotIsSet(this.suffixIsSet(), ImmutableDoi.MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_SUFFIX);
            this.suffix = Objects.requireNonNull(suffix, ImmutableDoi.MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_SUFFIX);
            return this;
        }

        public final Builder withIdentifier(String identifier) {
            Objects.requireNonNull(identifier, ImmutableDoi.MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_IDENTIFIER);
            int indexOfDivider = identifier.indexOf(47);
            if (indexOfDivider == -1) {
                throw new IllegalArgumentException("Invalid DOI identifier");
            }
            this.withPrefix(identifier.substring(0, indexOfDivider));
            this.withSuffix(identifier.substring(++indexOfDivider));
            return this;
        }

        public final Builder withDoi(URI doi) {
            Objects.requireNonNull(doi, ImmutableDoi.MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_DOI);
            if (Builder.containsOnlyLeadingForwardSlashAndSlashBetweenPrefixAndSuffix(doi)) {
                throw new IllegalArgumentException(ERROR_DOI_URI_INVALID_FORMAT.concat(doi.toASCIIString()));
            }
            this.withIdentifier(Builder.extractDoiPathWithoutLeadingForwardSlash(doi));
            this.withProxy(doi);
            return this;
        }

        public ImmutableDoi build() {
            if (this.hasPathInProxy()) {
                this.proxy = ImmutableDoi.createDoiUriWithoutIdentifier(this.proxy);
            }
            this.checkRequiredAttributes();
            this.validateProxy();
            this.validatePrefix();
            return new ImmutableDoi(this);
        }

        public boolean isNotHypertextTransferProtocol() {
            return !Doi.VALID_SCHEMES.contains(this.proxy.getScheme().toLowerCase(Locale.US));
        }

        private static String extractDoiPathWithoutLeadingForwardSlash(URI doi) {
            return doi.getPath().charAt(0) == '/' ? doi.getPath().substring(1) : doi.getPath();
        }

        private static boolean containsOnlyLeadingForwardSlashAndSlashBetweenPrefixAndSuffix(URI doi) {
            return doi.getPath().chars().filter(ch -> ch == 47).count() != 2L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException(ImmutableDoi.BUILDER_OF_DOI_IS_STRICT_ATTRIBUTE_IS_ALREADY_SET.concat(name));
            }
        }

        private boolean hasPathInProxy() {
            if (this.proxyIsSet()) {
                return this.isEmptyPathOrContainOnlyPathSeparator(this.proxy.getPath());
            }
            return false;
        }

        private boolean isEmptyPathOrContainOnlyPathSeparator(String proxyPath) {
            return proxyPath != null && (proxyPath.length() > 1 || proxyPath.length() > 0 && proxyPath.charAt(0) != '/');
        }

        private void validatePrefix() {
            if (!this.prefix.startsWith("10.") || this.prefix.length() <= "10.".length()) {
                throw new IllegalStateException(CANNOT_BUILD_DOI_DOI_PREFIX_IS_NOT_VALID);
            }
        }

        private void validateProxy() {
            if (this.proxyIsSet() && (this.isNotHypertextTransferProtocol() || this.isNotValidProxy())) {
                throw new IllegalStateException(ImmutableDoi.CANNOT_BUILD_DOI_PROXY_IS_NOT_A_VALID_PROXY);
            }
        }

        private boolean isNotValidProxy() {
            return !Doi.VALID_PROXIES.contains(this.proxy.getHost().toLowerCase(Locale.US));
        }

        private boolean proxyIsSet() {
            return Objects.nonNull(this.proxy);
        }

        private boolean prefixIsSet() {
            return Objects.nonNull(this.prefix);
        }

        private boolean suffixIsSet() {
            return Objects.nonNull(this.suffix);
        }

        private void checkRequiredAttributes() {
            if (!this.prefixIsSet() || !this.suffixIsSet()) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.prefixIsSet()) {
                attributes.add(ImmutableDoi.MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_PREFIX);
            }
            if (!this.suffixIsSet()) {
                attributes.add(ImmutableDoi.MESSAGE_NON_NULL_ARGUMENT_FOR_PARAMETER_SUFFIX);
            }
            return "Cannot build Doi, some of required attributes are not set " + attributes;
        }
    }
}

