/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.dynamodb;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.lambda.runtime.events.models.dynamodb.AttributeValue;
import com.amazonaws.util.BinaryUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import nva.commons.core.JacocoGenerated;

public final class ItemMapper {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private ItemMapper() {
    }

    @JacocoGenerated
    public static String toJsonFromEvent(Map<String, AttributeValue> eventAttributeValueMap) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)ItemMapper.toJsonNodeFromEvent(eventAttributeValueMap));
    }

    @JacocoGenerated
    public static String toJson(Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> attributeValueMap) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)ItemMapper.toJsonNode(attributeValueMap));
    }

    public static JsonNode toJsonNodeFromEvent(Map<String, AttributeValue> eventAttributeValueMap) throws JsonProcessingException {
        Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> attributeValueMap = ItemMapper.fromEvent(eventAttributeValueMap);
        return ItemMapper.toJsonNode(attributeValueMap);
    }

    public static JsonNode toJsonNode(Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> attributeValueMap) throws JsonProcessingException {
        Map<String, Object> object = ItemMapper.toObject(attributeValueMap);
        Item item = Item.fromMap(object);
        JsonNode jsonNode = objectMapper.readTree(item.toJSON());
        return jsonNode;
    }

    private static Map<String, Object> toObject(Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> attributeMap) {
        return ItemMapper.toSimpleMapValue(attributeMap);
    }

    private static Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> fromEvent(Map<String, AttributeValue> map) throws JsonProcessingException {
        String jsonString = objectMapper.writeValueAsString(map);
        JavaType javaType = objectMapper.getTypeFactory().constructParametricType(Map.class, new Class[]{String.class, com.amazonaws.services.dynamodbv2.model.AttributeValue.class});
        return (Map)objectMapper.readValue(jsonString, javaType);
    }

    @JacocoGenerated
    private static <T> Map<String, T> toSimpleMapValue(Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> values) {
        if (values == null) {
            return Map.of();
        }
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>(values.size());
        for (Map.Entry<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> entry : values.entrySet()) {
            T t = ItemMapper.toSimpleValue(entry.getValue());
            result.put(entry.getKey(), t);
        }
        return result;
    }

    private static <T> T toSimpleValue(com.amazonaws.services.dynamodbv2.model.AttributeValue value) {
        if (value == null) {
            return null;
        }
        if (Boolean.TRUE.equals(value.getNULL())) {
            return null;
        }
        if (Boolean.FALSE.equals(value.getNULL())) {
            throw new UnsupportedOperationException("False-NULL is not supported in DynamoDB");
        }
        if (value.getBOOL() != null) {
            Boolean t = value.getBOOL();
            return (T)t;
        }
        if (value.getS() != null) {
            String t = value.getS();
            return (T)t;
        }
        if (value.getN() != null) {
            BigDecimal t = new BigDecimal(value.getN());
            return (T)t;
        }
        if (value.getB() != null) {
            byte[] t = BinaryUtils.copyAllBytesFrom((ByteBuffer)value.getB());
            return (T)t;
        }
        if (value.getSS() != null) {
            LinkedHashSet t = new LinkedHashSet(value.getSS());
            return (T)t;
        }
        if (value.getNS() != null) {
            LinkedHashSet set = new LinkedHashSet(value.getNS().size());
            value.getNS().stream().map(BigDecimal::new).forEach(set::add);
            LinkedHashSet t = set;
            return (T)t;
        }
        if (value.getBS() != null) {
            LinkedHashSet<byte[]> set = new LinkedHashSet<byte[]>(value.getBS().size());
            for (ByteBuffer bb : value.getBS()) {
                set.add(BinaryUtils.copyAllBytesFrom((ByteBuffer)bb));
            }
            LinkedHashSet<byte[]> t = set;
            return (T)t;
        }
        if (value.getL() != null) {
            List<Object> t = ItemMapper.toSimpleList(value.getL());
            return (T)t;
        }
        if (value.getM() != null) {
            Map<String, T> t = ItemMapper.toSimpleMapValue(value.getM());
            return (T)t;
        }
        return null;
    }

    private static List<Object> toSimpleList(List<com.amazonaws.services.dynamodbv2.model.AttributeValue> attrValues) {
        if (attrValues == null) {
            return List.of();
        }
        ArrayList<Object> result = new ArrayList<Object>(attrValues.size());
        for (com.amazonaws.services.dynamodbv2.model.AttributeValue attrValue : attrValues) {
            Object value = ItemMapper.toSimpleValue(attrValue);
            result.add(value);
        }
        return result;
    }
}

