/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.identifiers;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;
import no.unit.nva.identifiers.SortableIdentifierDeserializer;
import no.unit.nva.identifiers.SortableIdentifierSerializer;

@JsonSerialize(using=SortableIdentifierSerializer.class)
@JsonDeserialize(using=SortableIdentifierDeserializer.class)
public final class SortableIdentifier
implements Comparable<SortableIdentifier> {
    public static final int UUID_LENGTH = 36;
    public static final int TIMESTAMP_LENGTH = 12;
    public static final int EXTRA_DASH = 1;
    public static final int SORTABLE_ID_LENGTH = 49;
    public static final String INVALID_SORTABLE_IDENTIFIER_ERROR = "Invalid sortable identifier";
    public static final String PATH_DELIMITER = "/";
    public static final String INVALID_URI_ERROR_MESSAGE = "The URI %s does not contain a valid Sortable identifier:";
    private static final String IDENTIFIER_FORMATTING = "%012x-%s";
    private final String identifier;

    public SortableIdentifier(String identifier) {
        this.validate(identifier);
        this.identifier = identifier;
    }

    public static SortableIdentifier next() {
        return new SortableIdentifier(SortableIdentifier.newIdentifierString());
    }

    public static SortableIdentifier fromUri(URI uri) {
        try {
            String path = uri.getPath();
            return new SortableIdentifier(path.substring(path.lastIndexOf(PATH_DELIMITER) + 1));
        }
        catch (Exception exception) {
            throw SortableIdentifier.invalidUriError(uri);
        }
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortableIdentifier that = (SortableIdentifier)o;
        return Objects.equals(this.toString(), that.toString());
    }

    public String toString() {
        return this.identifier;
    }

    @Override
    public int compareTo(SortableIdentifier o) {
        return this.toString().compareTo(o.toString());
    }

    private static IllegalArgumentException invalidUriError(URI uri) {
        return new IllegalArgumentException(String.format(INVALID_URI_ERROR_MESSAGE, uri.toString()));
    }

    private static String newIdentifierString() {
        return String.format(IDENTIFIER_FORMATTING, System.currentTimeMillis(), UUID.randomUUID());
    }

    private void validate(String identifier) {
        if (identifier.length() == 36 || identifier.length() == 49) {
            return;
        }
        throw new IllegalArgumentException(INVALID_SORTABLE_IDENTIFIER_ERROR);
    }
}

