/*
 * Decompiled with CFR 0.152.
 */
package no.unit.commons.apigateway.authentication;

import no.unit.commons.apigateway.authentication.RequestAuthorizer;
import nva.commons.core.Environment;
import nva.commons.core.JacocoGenerated;
import nva.commons.secrets.SecretsReader;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;

public class DefaultRequestAuthorizer
extends RequestAuthorizer {
    private static final Environment ENVIRONMENT = new Environment();
    public static final String API_KEY_SECRET_NAME = ENVIRONMENT.readEnv("API_KEY_SECRET_NAME");
    public static final String API_KEY_SECRET_KEY = ENVIRONMENT.readEnv("API_KEY_SECRET_KEY");
    private final SecretsReader secretsReader;
    private final String principalIdentifier;

    @JacocoGenerated
    public DefaultRequestAuthorizer(String principalId) {
        this(SecretsReader.defaultSecretsManagerClient(), principalId);
    }

    public DefaultRequestAuthorizer(SecretsManagerClient secretsClient, String principalId) {
        this.secretsReader = new SecretsReader(secretsClient);
        this.principalIdentifier = principalId;
    }

    @Override
    protected String principalId() {
        return this.principalIdentifier;
    }

    @Override
    protected String fetchSecret() {
        return this.secretsReader.fetchSecret(API_KEY_SECRET_NAME, API_KEY_SECRET_KEY);
    }
}

