/*
 * Decompiled with CFR 0.152.
 */
package no.unit.commons.apigateway.authentication;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import no.unit.commons.apigateway.authentication.StatementElement;
import nva.commons.core.JacocoGenerated;

public class AuthPolicy {
    public static final String VERSION = "2012-10-17";
    @JsonProperty(value="Version")
    private String version;
    @JsonProperty(value="Statement")
    private List<StatementElement> statement;

    public AuthPolicy() {
    }

    private AuthPolicy(Builder builder) {
        this.setVersion(VERSION);
        this.setStatement(builder.statement);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<StatementElement> getStatement() {
        return this.statement;
    }

    public void setStatement(List<StatementElement> statement) {
        this.statement = statement;
    }

    @JacocoGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthPolicy that = (AuthPolicy)o;
        return this.equalVersions(that) && this.equalStatements(that.getStatement());
    }

    @JacocoGenerated
    public int hashCode() {
        return Objects.hash(this.getVersion(), this.getStatement());
    }

    private boolean equalStatements(List<StatementElement> otherStatement) {
        boolean leftContainsRight = new HashSet<StatementElement>(this.statement).containsAll(otherStatement);
        boolean rightContainsLeft = new HashSet<StatementElement>(otherStatement).containsAll(this.statement);
        return leftContainsRight && rightContainsLeft;
    }

    private boolean equalVersions(AuthPolicy that) {
        return Objects.equals(this.getVersion(), that.getVersion());
    }

    public static final class Builder {
        private List<StatementElement> statement;

        private Builder() {
        }

        public Builder withStatement(List<StatementElement> val) {
            this.statement = val;
            return this;
        }

        public AuthPolicy build() {
            return new AuthPolicy(this);
        }
    }
}

