/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.logutils;

import java.util.Objects;
import nva.commons.logutils.TestAppender;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;

public final class LogUtils {
    public static final String PATTERN_ATTRIBUTE_NAME = "pattern";
    public static final String LOG_CLASS_NAME_AND_MESSAGE = "%c{1.}:  %msg";
    public static final String ROOT_NULL_APPENDER = "NullAppender";
    public static final String PACKAGES_WITH_APPENDERS = "nva.commons.logutils";

    private LogUtils() {
    }

    public static <T> TestAppender getTestingAppender(Class<T> clazz) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        LogUtils.avoidStatusMessagesWhileSettingUpConfiguration((ConfigurationBuilder<BuiltConfiguration>)builder);
        LogUtils.enableLog4jToFindOurAppender((ConfigurationBuilder<BuiltConfiguration>)builder);
        LogUtils.addTestAppenderToConfig((ConfigurationBuilder<BuiltConfiguration>)builder);
        LogUtils.silenceRoot((ConfigurationBuilder<BuiltConfiguration>)builder);
        LogUtils.addLoggerForTheInputClass(clazz, (ConfigurationBuilder<BuiltConfiguration>)builder);
        LogUtils.reconfigureBuilder((ConfigurationBuilder<BuiltConfiguration>)builder);
        return (TestAppender)LogUtils.createReferenceToTheAppenderInstanceForTestingAssertions(context);
    }

    public static <T> TestAppender getTestingAppenderForRootLogger() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        LogUtils.avoidStatusMessagesWhileSettingUpConfiguration((ConfigurationBuilder<BuiltConfiguration>)builder);
        LogUtils.enableLog4jToFindOurAppender((ConfigurationBuilder<BuiltConfiguration>)builder);
        LogUtils.addTestAppenderToConfig((ConfigurationBuilder<BuiltConfiguration>)builder);
        LogUtils.addRootLogger((ConfigurationBuilder<BuiltConfiguration>)builder);
        LogUtils.reconfigureBuilder((ConfigurationBuilder<BuiltConfiguration>)builder);
        return (TestAppender)LogUtils.createReferenceToTheAppenderInstanceForTestingAssertions(context);
    }

    public static String toLoggerName(Class<?> cls) {
        String canonicalName = cls.getCanonicalName();
        return Objects.nonNull(canonicalName) ? canonicalName : cls.getName();
    }

    private static void reconfigureBuilder(ConfigurationBuilder<BuiltConfiguration> builder) {
        Configurator.reconfigure((Configuration)((Configuration)builder.build()));
    }

    private static Appender createReferenceToTheAppenderInstanceForTestingAssertions(LoggerContext context) {
        return context.getConfiguration().getAppender("Test");
    }

    private static <T> void addRootLogger(ConfigurationBuilder<BuiltConfiguration> builder) {
        RootLoggerComponentBuilder loggerBuilder = builder.newRootLogger(Level.DEBUG);
        loggerBuilder.addAttribute("additivity", false);
        loggerBuilder.add(builder.newAppenderRef("Test"));
        builder.add(loggerBuilder);
    }

    private static <T> void addLoggerForTheInputClass(Class<T> clazz, ConfigurationBuilder<BuiltConfiguration> builder) {
        LoggerComponentBuilder loggerBuilder = builder.newLogger(clazz.getName(), Level.DEBUG);
        loggerBuilder.addAttribute("additivity", false);
        loggerBuilder.add(builder.newAppenderRef("Test"));
        builder.add(loggerBuilder);
    }

    private static void silenceRoot(ConfigurationBuilder<BuiltConfiguration> builder) {
        builder.newAppender(ROOT_NULL_APPENDER, "Null");
        RootLoggerComponentBuilder rootLogger = builder.newRootLogger(Level.DEBUG);
        rootLogger.add(builder.newAppenderRef(ROOT_NULL_APPENDER));
        builder.add(rootLogger);
    }

    private static AppenderComponentBuilder addTestAppenderToConfig(ConfigurationBuilder<BuiltConfiguration> builder) {
        AppenderComponentBuilder appenderBuilder = builder.newAppender("Test", "TestAppender");
        LayoutComponentBuilder classAndMessage = builder.newLayout("PatternLayout");
        classAndMessage.addAttribute(PATTERN_ATTRIBUTE_NAME, LOG_CLASS_NAME_AND_MESSAGE);
        appenderBuilder.add(classAndMessage);
        builder.add(appenderBuilder);
        return appenderBuilder;
    }

    private static void enableLog4jToFindOurAppender(ConfigurationBuilder<BuiltConfiguration> builder) {
        builder.setPackages(PACKAGES_WITH_APPENDERS);
    }

    private static ConfigurationBuilder<BuiltConfiguration> avoidStatusMessagesWhileSettingUpConfiguration(ConfigurationBuilder<BuiltConfiguration> builder) {
        return builder.setStatusLevel(Level.DEBUG);
    }
}

