/*
 * Decompiled with CFR 0.152.
 */
package nva.commons.logutils;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="TestAppender", category="Core", elementType="appender", printObject=true)
public class TestAppender
extends AbstractAppender {
    public static final String PLUGIN_NAME = "TestAppender";
    public static final String APPENDER_NAME = "Test";
    private final StringBuilder stringBuffer = new StringBuilder();

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public TestAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
        byte[] bytes = super.getLayout().toByteArray(event);
        String logLine = new String(bytes, StandardCharsets.UTF_8);
        this.stringBuffer.append(logLine);
    }

    public String getMessages() {
        return this.stringBuffer.toString();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<TestAppender> {
        public TestAppender build() {
            return new TestAppender(super.getName(), super.getFilter(), (Layout<? extends Serializable>)super.getOrCreateLayout(), super.isIgnoreExceptions());
        }
    }
}

