/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.testutils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.util.List;
import no.unit.nva.commons.json.JsonSerializable;
import no.unit.nva.commons.json.JsonUtils;
import no.unit.nva.events.models.AwsEventBridgeDetail;
import no.unit.nva.events.models.AwsEventBridgeEvent;
import no.unit.nva.testutils.RandomDataGenerator;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;
import nva.commons.core.ioutils.IoUtils;
import software.amazon.awssdk.regions.Region;

@JacocoGenerated
public final class EventBridgeEventBuilder {
    public static final ObjectNode EMPTY_OBJECT = JsonUtils.dtoObjectMapper.createObjectNode();

    private EventBridgeEventBuilder() {
    }

    @JacocoGenerated
    public static <T> InputStream sampleLambdaDestinationsEvent(T eventBody) {
        AwsEventBridgeDetail<T> detail = EventBridgeEventBuilder.createDestinationsEventDetailBody(eventBody);
        AwsEventBridgeEvent<AwsEventBridgeDetail<T>> event = EventBridgeEventBuilder.sampleEventObject(detail);
        return (InputStream)Try.of(event).map(JsonSerializable::toJsonString).map(IoUtils::stringToStream).orElseThrow();
    }

    @JacocoGenerated
    public static <T> InputStream sampleEvent(T detail) {
        return (InputStream)Try.of(EventBridgeEventBuilder.sampleEventObject(detail)).map(JsonSerializable::toJsonString).map(IoUtils::stringToStream).orElseThrow();
    }

    @JacocoGenerated
    public static <T> AwsEventBridgeEvent<T> sampleEventObject(T detail) {
        AwsEventBridgeEvent event = new AwsEventBridgeEvent();
        event.setDetail(detail);
        event.setVersion(RandomDataGenerator.randomString());
        event.setResources(List.of(RandomDataGenerator.randomString()));
        event.setId(RandomDataGenerator.randomString());
        event.setRegion((Region)RandomDataGenerator.randomElement(Region.regions()));
        event.setTime(RandomDataGenerator.randomInstant());
        event.setSource(RandomDataGenerator.randomString());
        event.setAccount(RandomDataGenerator.randomString());
        return event;
    }

    @JacocoGenerated
    private static <T> AwsEventBridgeDetail<T> createDestinationsEventDetailBody(T eventBody) {
        return AwsEventBridgeDetail.newBuilder().withRequestPayload((JsonNode)EMPTY_OBJECT).withTimestamp(RandomDataGenerator.randomInstant().toString()).withVersion(RandomDataGenerator.randomString()).withResponsePayload(eventBody).build();
    }
}

