/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.stubs;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.net.URI;
import java.util.Map;
import no.unit.nva.auth.CognitoUserInfo;
import no.unit.nva.commons.json.JsonUtils;
import no.unit.nva.testutils.RandomDataGenerator;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.attempt.Try;

public class FakeAuthServer {
    public static final String ACCESS_TOKEN_TEMPLATE = "{\"access_token\": \"%s\"}";
    public static final String ACCESS_TOKEN_FORBIDDEN = RandomDataGenerator.randomString();
    public static final String FORBIDDEN_BODY = RandomDataGenerator.randomString();
    private WireMockServer httpServer;
    private URI serverUri;
    private Map<String, CognitoUserInfo> accessTokenUserMap;

    public FakeAuthServer() {
        this.initialize();
        this.stubForbidden();
    }

    public void close() {
        this.httpServer.stop();
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public void setUserBase(Map<String, CognitoUserInfo> accessTokenToUserMap) {
        this.accessTokenUserMap = accessTokenToUserMap;
        this.accessTokenUserMap.keySet().forEach(this::stubEndpointForUserEntry);
    }

    public String createHttpInteractions(String clientId, String clientSecret, String expectedAccessToken, String exampleResourcePath) {
        this.createOAuthAccessTokenResponse(clientId, clientSecret, expectedAccessToken);
        return this.createResponseForProtectedContent(expectedAccessToken, exampleResourcePath);
    }

    public String createResponseForProtectedContent(String expectedAccessToken, String exampleResourcePath) {
        String protectedContent = RandomDataGenerator.randomString();
        WireMock.stubFor((MappingBuilder)WireMock.get((String)exampleResourcePath).withHeader("Authorization", (StringValuePattern)new EqualToPattern("Bearer " + expectedAccessToken)).willReturn(WireMock.aResponse().withBody(protectedContent).withStatus(200)));
        return protectedContent;
    }

    public void createOAuthAccessTokenResponse(String clientId, String clientSecret, String expectedAccessToken) {
        String body = String.format(ACCESS_TOKEN_TEMPLATE, expectedAccessToken);
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/oauth2/token").withBasicAuth(clientId, clientSecret).withRequestBody((ContentPattern)new ContainsPattern("grant_type=client_credentials")).willReturn(this.createOauthClientResponse(body, 200)));
    }

    @JacocoGenerated
    public void createOAuthAccessTokenResponseForbidden(String clientId, String clientSecret) {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/oauth2/token").withBasicAuth(clientId, clientSecret).withRequestBody((ContentPattern)new ContainsPattern("grant_type=client_credentials")).willReturn(this.createOauthClientResponse("{}", 403)));
    }

    @JacocoGenerated
    public void createOAuthAccessTokenResponseMissingToken(String clientId, String clientSecret) {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)"/oauth2/token").withBasicAuth(clientId, clientSecret).withRequestBody((ContentPattern)new ContainsPattern("grant_type=client_credentials")).willReturn(this.createOauthClientResponse("{}", 200)));
    }

    private void initialize() {
        this.httpServer = new WireMockServer((Options)WireMockConfiguration.options().httpDisabled(true).dynamicHttpsPort());
        this.httpServer.start();
        this.serverUri = URI.create(this.httpServer.baseUrl());
        WireMock.configureFor((String)"https", (String)this.serverUri.getHost(), (int)this.httpServer.httpsPort());
    }

    private void stubEndpointForUserEntry(String accessToken) {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/oauth2/userInfo").withHeader("Authorization", WireMock.equalTo((String)this.bearerToken(accessToken))).willReturn(this.createUserInfoResponse(accessToken)));
    }

    private void stubForbidden() {
        WireMock.stubFor((MappingBuilder)WireMock.get((String)"/oauth2/userInfo").withHeader("Authorization", WireMock.equalTo((String)this.bearerToken(ACCESS_TOKEN_FORBIDDEN))).willReturn(this.createForbiddenResponse()));
    }

    private ResponseDefinitionBuilder createForbiddenResponse() {
        return WireMock.aResponse().withStatus(403).withBody(FORBIDDEN_BODY);
    }

    private ResponseDefinitionBuilder createOauthClientResponse(String body, int statusCode) {
        return WireMock.aResponse().withStatus(statusCode).withBody(body);
    }

    private ResponseDefinitionBuilder createUserInfoResponse(String accessToken) {
        return WireMock.aResponse().withBody(this.userInfoString(accessToken)).withStatus(200);
    }

    private String userInfoString(String accessToken) {
        CognitoUserInfo userInfo = this.accessTokenUserMap.get(accessToken);
        return (String)Try.attempt(() -> JsonUtils.dtoObjectMapper.writeValueAsString((Object)userInfo)).orElseThrow();
    }

    private String bearerToken(String accessToken) {
        return "Bearer " + accessToken;
    }
}

