/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.stubs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nva.commons.core.JacocoGenerated;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;
import software.amazon.awssdk.services.eventbridge.model.EventBus;
import software.amazon.awssdk.services.eventbridge.model.ListEventBusesRequest;
import software.amazon.awssdk.services.eventbridge.model.ListEventBusesResponse;
import software.amazon.awssdk.services.eventbridge.model.PutEventsRequest;
import software.amazon.awssdk.services.eventbridge.model.PutEventsRequestEntry;
import software.amazon.awssdk.services.eventbridge.model.PutEventsResponse;

public class FakeEventBridgeClient
implements EventBridgeClient {
    private final List<PutEventsRequestEntry> requestEntries = new ArrayList<PutEventsRequestEntry>();
    private final List<String> eventBusNames;
    private final Integer mockFailedEntryCount;

    @JacocoGenerated
    public FakeEventBridgeClient(String ... eventBusNames) {
        this.eventBusNames = Arrays.asList(eventBusNames);
        this.mockFailedEntryCount = 0;
    }

    @JacocoGenerated
    public FakeEventBridgeClient(int failCount, String ... eventBusNames) {
        this.eventBusNames = Arrays.asList(eventBusNames);
        this.mockFailedEntryCount = failCount;
    }

    @JacocoGenerated
    public List<PutEventsRequestEntry> getRequestEntries() {
        return this.requestEntries;
    }

    public ListEventBusesResponse listEventBuses(ListEventBusesRequest listEventBusesRequest) {
        List buses = this.eventBusNames.stream().map(busName -> (EventBus)EventBus.builder().name(busName).build()).collect(Collectors.toList());
        return (ListEventBusesResponse)ListEventBusesResponse.builder().eventBuses(buses).build();
    }

    @JacocoGenerated
    public PutEventsResponse putEvents(PutEventsRequest putEventsRequest) {
        this.requestEntries.addAll(putEventsRequest.entries());
        return (PutEventsResponse)PutEventsResponse.builder().failedEntryCount(this.mockFailedEntryCount).build();
    }

    @JacocoGenerated
    public String serviceName() {
        return "FakeEventBridgeClient";
    }

    @JacocoGenerated
    public void close() {
    }
}

