/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.stubs;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import nva.commons.core.JacocoGenerated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.firehose.FirehoseClient;
import software.amazon.awssdk.services.firehose.model.FirehoseException;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordResponse;
import software.amazon.awssdk.services.firehose.model.Record;

public class FakeFirehoseClient
implements FirehoseClient {
    public static final String EMPTY_RECORDS_MESSAGE_TEMPLATE = "Value %s at 'records' failed to satisfy constraint: Member must have length greater than or equal to 1";
    private final List<Record> records = new ArrayList<Record>();

    public PutRecordResponse putRecord(PutRecordRequest putRecordRequest) {
        this.records.add(putRecordRequest.record());
        return (PutRecordResponse)PutRecordResponse.builder().build();
    }

    public PutRecordBatchResponse putRecordBatch(PutRecordBatchRequest putRecordBatchRequest) {
        if (putRecordBatchRequest.records().isEmpty()) {
            throw this.emptyBatchException();
        }
        this.records.addAll(putRecordBatchRequest.records());
        return (PutRecordBatchResponse)PutRecordBatchResponse.builder().build();
    }

    @JacocoGenerated
    public String serviceName() {
        return "FakeFirehoseClient";
    }

    @JacocoGenerated
    public void close() {
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public Stream<String> extractPushedContent() {
        return this.getRecords().stream().map(Record::data).map(data -> data.asString(StandardCharsets.UTF_8));
    }

    public <T> Stream<T> extractPushedContent(Function<String, T> parser) {
        return this.extractPushedContent().map(parser::apply);
    }

    private AwsServiceException emptyBatchException() {
        return FirehoseException.builder().message(String.format(EMPTY_RECORDS_MESSAGE_TEMPLATE, this.records)).build();
    }
}

