/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.testutils;

final class IssnGenerator {
    public static final String SYMBOL_FOR_NUMBER_TEN = "X";
    private static final int MIDDLE_INDEX_OF_ISSN_STRING = 4;

    private IssnGenerator() {
    }

    public static String randomInvalidIssn() {
        return IssnGenerator.createInvalidIssn(IssnGenerator.random7DigitNumber());
    }

    public static String randomIssn() {
        return IssnGenerator.createValidIssn(IssnGenerator.random7DigitNumber());
    }

    private static String random7DigitNumber() {
        return String.valueOf((int)(Math.random() * 9000000.0) + 1000000);
    }

    private static String createInvalidIssn(String issnMissingChecksum) {
        int issnDigitsSum = IssnGenerator.calculateIssnDigitSum(issnMissingChecksum);
        int wrongSum = issnDigitsSum - 1;
        String issnWithChecksum = IssnGenerator.createIssnWithCheckSum(issnMissingChecksum, wrongSum);
        return IssnGenerator.formatIssnString(issnWithChecksum);
    }

    private static String createValidIssn(String issnMissingChecksum) {
        int issnDigitsSum = IssnGenerator.calculateIssnDigitSum(issnMissingChecksum);
        String issnWithChecksum = IssnGenerator.createIssnWithCheckSum(issnMissingChecksum, issnDigitsSum);
        return IssnGenerator.formatIssnString(issnWithChecksum);
    }

    private static String formatIssnString(String issnWithChecksum) {
        return issnWithChecksum.substring(0, 4) + "-" + issnWithChecksum.substring(4);
    }

    private static int calculateIssnDigitSum(String issnMissingChecksum) {
        int issnDigitsSum = 0;
        for (int i = 0; i < issnMissingChecksum.length(); ++i) {
            int number = Integer.parseInt(Character.toString(issnMissingChecksum.charAt(i)));
            issnDigitsSum += (8 - i) * number;
        }
        return issnDigitsSum;
    }

    private static String createIssnWithCheckSum(String issnMissingChecksum, int totalSum) {
        int mod11 = totalSum % 11;
        int checksum = mod11 == 0 ? 0 : 11 - mod11;
        return checksum == 10 ? issnMissingChecksum + SYMBOL_FOR_NUMBER_TEN : issnMissingChecksum + checksum;
    }
}

