/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.testutils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import no.unit.nva.testutils.RandomDataGenerator;

public final class JwtTestToken {
    private JwtTestToken() {
    }

    public static String randomToken() {
        Date issuedAt = new Date();
        Date expiresAt = new Date(issuedAt.getTime() + TimeUnit.HOURS.toMillis(1L));
        return JwtTestToken.randomToken(issuedAt, expiresAt);
    }

    public static String randomExpiredToken() {
        Date issuedAt = new Date(new Date().getTime() - TimeUnit.HOURS.toMillis(1L));
        Date expiresAt = new Date(issuedAt.getTime() + TimeUnit.MINUTES.toMillis(1L));
        return JwtTestToken.randomToken(issuedAt, expiresAt);
    }

    private static String randomToken(Date issuedAt, Date expiresAt) {
        return JwtTestToken.newToken(RandomDataGenerator.randomString(), RandomDataGenerator.randomString(), issuedAt, expiresAt, Algorithm.HMAC256((String)RandomDataGenerator.randomString()));
    }

    private static String newToken(String issuer, String subject, Date issuedAt, Date expiresAt, Algorithm algorithm) {
        return JWT.create().withIssuer(issuer).withSubject(subject).withIssuedAt(issuedAt).withExpiresAt(expiresAt).sign(algorithm);
    }
}

