/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.stubs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import nva.commons.core.JacocoGenerated;
import nva.commons.core.ioutils.IoUtils;
import nva.commons.core.paths.UnixPath;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Object;

@JacocoGenerated
public class FakeS3Client
implements S3Client {
    private static final int START_FROM_BEGINNING = 0;
    private final Map<String, ByteBuffer> filesAndContent;

    public FakeS3Client(String ... filesInBucket) {
        this(FakeS3Client.readResourceFiles(filesInBucket));
    }

    public FakeS3Client(Map<String, ByteBuffer> filesAndContent) {
        this.filesAndContent = new LinkedHashMap<String, ByteBuffer>(filesAndContent);
    }

    public static FakeS3Client fromContentsMap(Map<String, InputStream> filesAndContent) {
        Map<String, ByteBuffer> toByteBuffer = filesAndContent.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> FakeS3Client.inputSteamToByteBuffer((InputStream)entry.getValue())));
        return new FakeS3Client(toByteBuffer);
    }

    public <T> T getObject(GetObjectRequest getObjectRequest, ResponseTransformer<GetObjectResponse, T> responseTransformer) {
        String filename = getObjectRequest.key();
        byte[] contents = this.extractContent(filename).array();
        GetObjectResponse response = (GetObjectResponse)GetObjectResponse.builder().contentLength(Long.valueOf(contents.length)).build();
        return this.transformResponse(responseTransformer, new ByteArrayInputStream(contents), response);
    }

    public ListObjectsResponse listObjects(ListObjectsRequest listObjectsRequest) {
        ArrayList<String> fileKeys = new ArrayList<String>(this.filesAndContent.keySet());
        int startIndex = this.calculateStartIndex(fileKeys, listObjectsRequest.marker());
        int excludedEndIndex = this.calculateEndIndex(fileKeys, listObjectsRequest.marker(), listObjectsRequest.maxKeys());
        List files = fileKeys.subList(startIndex, excludedEndIndex).stream().filter(filePath -> this.filePathIsInSpecifiedParentFolder((String)filePath, listObjectsRequest)).map(filename -> (S3Object)S3Object.builder().key(filename).build()).collect(Collectors.toList());
        String nextStartListingPoint = this.calculateNestStartListingPoint(fileKeys, excludedEndIndex);
        return (ListObjectsResponse)ListObjectsResponse.builder().contents(files).nextMarker(nextStartListingPoint).isTruncated(Boolean.valueOf(Objects.nonNull(nextStartListingPoint))).build();
    }

    public ListObjectsV2Response listObjectsV2(ListObjectsV2Request v2Request) {
        ListObjectsRequest oldRequest = (ListObjectsRequest)ListObjectsRequest.builder().bucket(v2Request.bucket()).marker(v2Request.continuationToken()).maxKeys(v2Request.maxKeys()).prefix(v2Request.prefix()).build();
        ListObjectsResponse oldResponse = this.listObjects(oldRequest);
        return (ListObjectsV2Response)ListObjectsV2Response.builder().contents((Collection)oldResponse.contents()).isTruncated(oldResponse.isTruncated()).continuationToken(v2Request.continuationToken()).nextContinuationToken(oldResponse.nextMarker()).build();
    }

    public PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) {
        String path = putObjectRequest.key();
        InputStream inputStream = requestBody.contentStreamProvider().newStream();
        this.filesAndContent.put(path, FakeS3Client.inputSteamToByteBuffer(inputStream));
        SdkHttpFullResponse sdkHttpResponse = SdkHttpResponse.builder().statusCode(200).build();
        return (PutObjectResponse)PutObjectResponse.builder().sdkHttpResponse((SdkHttpResponse)sdkHttpResponse).build();
    }

    public DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) {
        String path = deleteObjectRequest.key();
        this.filesAndContent.remove(path);
        return (DeleteObjectResponse)DeleteObjectResponse.builder().build();
    }

    public String serviceName() {
        return "FakeS3Client";
    }

    public void close() {
    }

    private String calculateNestStartListingPoint(List<String> fileKeys, int excludedEndIndex) {
        return excludedEndIndex >= fileKeys.size() ? null : fileKeys.get(excludedEndIndex - 1);
    }

    private static Map<String, ByteBuffer> readResourceFiles(String ... filesInBucket) {
        List<String> suppliedFilenames = Arrays.asList(filesInBucket);
        return suppliedFilenames.stream().map(filename -> new AbstractMap.SimpleEntry<String, ByteBuffer>((String)filename, FakeS3Client.readFileFromResources(filename))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private static ByteBuffer readFileFromResources(String filename) {
        InputStream inputStream = IoUtils.inputStreamFromResources((String)filename);
        return FakeS3Client.inputSteamToByteBuffer(inputStream);
    }

    private static ByteBuffer inputSteamToByteBuffer(InputStream inputStream) {
        return ByteBuffer.wrap(FakeS3Client.readAllBytes(inputStream));
    }

    private static byte[] readAllBytes(InputStream inputStream) {
        try {
            return inputStream.readAllBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean filePathIsInSpecifiedParentFolder(String filePathString, ListObjectsRequest listObjectsRequest) {
        UnixPath filePath = UnixPath.of((String[])new String[]{filePathString}).removeRoot();
        UnixPath parentFolder = Optional.of(listObjectsRequest).map(ListObjectsRequest::prefix).map(xva$0 -> UnixPath.of((String[])new String[]{xva$0})).map(UnixPath::removeRoot).orElse(UnixPath.EMPTY_PATH);
        return parentFolder.isEmptyPath() || parentFolder.isRoot() || filePath.toString().startsWith(parentFolder.toString());
    }

    private int calculateEndIndex(List<String> fileKeys, String marker, Integer pageSize) {
        int startIndex = this.calculateStartIndex(fileKeys, marker);
        return Math.min(startIndex + pageSize, fileKeys.size());
    }

    private int calculateStartIndex(List<String> fileKeys, String marker) {
        if (Objects.isNull(marker)) {
            return 0;
        }
        int calculatedStartIndex = FakeS3Client.indexOfLastReadFile(fileKeys, marker) + 1;
        if (calculatedStartIndex < fileKeys.size()) {
            return calculatedStartIndex;
        }
        throw new IllegalStateException("Start index is out of bounds in FakeS3Client");
    }

    private static int indexOfLastReadFile(List<String> fileKeys, String marker) {
        int indexOfLastFileRead = fileKeys.indexOf(marker);
        if (indexOfLastFileRead < 0) {
            throw new IllegalArgumentException("Marker/ContinuationToken is not valid");
        }
        return indexOfLastFileRead;
    }

    private ByteBuffer extractContent(String filename) {
        if (this.filesAndContent.containsKey(filename)) {
            return this.filesAndContent.get(filename);
        }
        throw (NoSuchKeyException)NoSuchKeyException.builder().message("File does not exist:" + filename).build();
    }

    private <T> T transformResponse(ResponseTransformer<GetObjectResponse, T> responseTransformer, InputStream inputStream, GetObjectResponse response) {
        try {
            return (T)responseTransformer.transform((Object)response, AbortableInputStream.create((InputStream)inputStream));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

