/*
 * Decompiled with CFR 0.152.
 */
package no.unit.nva.hamcrest;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import no.unit.nva.hamcrest.PropertyValuePair;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class DoesNotHaveEmptyValues<T>
extends BaseMatcher<T> {
    public static final String EMPTY_FIELD_ERROR = "Empty field found: ";
    public static final String FIELD_DELIMITER = ",";
    public static final String TEST_DESCRIPTION = "All fields of all included objects need to be non empty";
    private final List<PropertyValuePair> emptyFields;
    private Set<Class<?>> stopRecursionClasses = this.classesWithNoPojoStructure();
    private Set<String> ignoreFields = Collections.emptySet();

    public DoesNotHaveEmptyValues() {
        this.emptyFields = new ArrayList<PropertyValuePair>();
    }

    public static <R> DoesNotHaveEmptyValues<R> doesNotHaveEmptyValues() {
        return new DoesNotHaveEmptyValues();
    }

    public static <R> DoesNotHaveEmptyValues<R> doesNotHaveEmptyValuesIgnoringClasses(Set<Class<?>> ignoreList) {
        DoesNotHaveEmptyValues matcher = new DoesNotHaveEmptyValues();
        DoesNotHaveEmptyValues.initializeClassesWhereRecursiveFieldCheckingWillStop(ignoreList, matcher);
        return matcher;
    }

    public static <R> DoesNotHaveEmptyValues<R> doesNotHaveEmptyValuesIgnoringFields(Set<String> ignoreList) {
        DoesNotHaveEmptyValues matcher = new DoesNotHaveEmptyValues();
        DoesNotHaveEmptyValues.initializeFieldNamesWhichWillBeIgnoredDuringChecking(ignoreList, matcher);
        return matcher;
    }

    public static <R> DoesNotHaveEmptyValues<R> doesNotHaveEmptyValuesIgnoringFieldsAndClasses(Set<Class<?>> ignoreClassesList, Set<String> ignoreFieldsList) {
        DoesNotHaveEmptyValues matcher = new DoesNotHaveEmptyValues();
        DoesNotHaveEmptyValues.initializeClassesWhereRecursiveFieldCheckingWillStop(ignoreClassesList, matcher);
        DoesNotHaveEmptyValues.initializeFieldNamesWhichWillBeIgnoredDuringChecking(ignoreFieldsList, matcher);
        return matcher;
    }

    public boolean matches(Object actual) {
        return this.objectDoesNotHaveFieldsWithEmptyValues(PropertyValuePair.rootObject(actual));
    }

    public boolean objectDoesNotHaveFieldsWithEmptyValues(PropertyValuePair fieldValue) {
        List<PropertyValuePair> fieldsToBeChecked = this.createListWithFieldsToBeChecked(fieldValue);
        this.emptyFields.addAll(this.collectEmptyFields(fieldsToBeChecked));
        return this.emptyFields.isEmpty();
    }

    public void describeTo(Description description) {
        description.appendText(TEST_DESCRIPTION);
    }

    public void describeMismatch(Object item, Description description) {
        String emptyFieldNames = this.emptyFields.stream().map(PropertyValuePair::getFieldPath).collect(Collectors.joining(FIELD_DELIMITER));
        description.appendText(EMPTY_FIELD_ERROR).appendText(emptyFieldNames);
    }

    private static <R> void initializeFieldNamesWhichWillBeIgnoredDuringChecking(Set<String> ignoreList, DoesNotHaveEmptyValues<R> matcher) {
        matcher.ignoreFields = DoesNotHaveEmptyValues.addFieldPathDelimiterToRootField(ignoreList);
    }

    private static <R> void initializeClassesWhereRecursiveFieldCheckingWillStop(Set<Class<?>> ignoreList, DoesNotHaveEmptyValues<R> matcher) {
        HashSet newStopRecursionClasses = new HashSet();
        newStopRecursionClasses.addAll(matcher.stopRecursionClasses);
        newStopRecursionClasses.addAll(ignoreList);
        matcher.stopRecursionClasses = newStopRecursionClasses;
    }

    private static Set<String> addFieldPathDelimiterToRootField(Set<String> ignoreList) {
        return ignoreList.stream().map(DoesNotHaveEmptyValues::addPathDelimiterToTopLevelFields).collect(Collectors.toSet());
    }

    private static String addPathDelimiterToTopLevelFields(String f) {
        if (f.startsWith(".")) {
            return f;
        }
        return "." + f;
    }

    private List<PropertyValuePair> createListWithFieldsToBeChecked(PropertyValuePair rootObject) {
        ArrayList<PropertyValuePair> fieldsToBeChecked = new ArrayList<PropertyValuePair>();
        Stack<PropertyValuePair> fieldsToBeVisited = this.initializeFieldsToBeVisited(rootObject);
        while (!fieldsToBeVisited.isEmpty()) {
            PropertyValuePair currentField = fieldsToBeVisited.pop();
            if (!currentField.shouldBeChecked(this.stopRecursionClasses, this.ignoreFields)) continue;
            this.addNestedFieldsToFieldsToBeVisited(fieldsToBeVisited, currentField);
            fieldsToBeChecked.add(currentField);
        }
        return fieldsToBeChecked;
    }

    private Stack<PropertyValuePair> initializeFieldsToBeVisited(PropertyValuePair rootObject) {
        Stack<PropertyValuePair> fieldsToBeVisited = new Stack<PropertyValuePair>();
        fieldsToBeVisited.add(rootObject);
        return fieldsToBeVisited;
    }

    private void addNestedFieldsToFieldsToBeVisited(Collection<PropertyValuePair> fieldsToBeVisited, PropertyValuePair currentField) {
        if (currentField.isComplexObject()) {
            fieldsToBeVisited.addAll(currentField.children());
        } else if (currentField.isCollection()) {
            this.addEachArrayElementAsFieldToBeVisited(fieldsToBeVisited, currentField);
        }
    }

    private void addEachArrayElementAsFieldToBeVisited(Collection<PropertyValuePair> fieldsToBeVisited, PropertyValuePair currentField) {
        List<PropertyValuePair> collectionElements = currentField.createPropertyValuePairsForEachCollectionItem();
        fieldsToBeVisited.addAll(collectionElements);
    }

    private Set<Class<?>> classesWithNoPojoStructure() {
        return Set.of(URI.class, URL.class);
    }

    private List<PropertyValuePair> collectEmptyFields(List<PropertyValuePair> propertyValuePairs) {
        return propertyValuePairs.stream().filter(propertyValue -> this.isEmpty(propertyValue.getValue())).toList();
    }

    private boolean isEmpty(Object value) {
        if (Objects.isNull(value)) {
            return true;
        }
        return this.isBlankString(value) || this.isEmptyCollection(value) || this.isEmptyMap(value) || this.isEmptyJsonNode(value);
    }

    private boolean isEmptyMap(Object value) {
        Map map;
        return value instanceof Map && (map = (Map)value).isEmpty();
    }

    private boolean isEmptyJsonNode(Object value) {
        JsonNode json;
        return value instanceof JsonNode && (json = (JsonNode)value).isEmpty();
    }

    private boolean isEmptyCollection(Object value) {
        Collection collection;
        return value instanceof Collection && (collection = (Collection)value).isEmpty();
    }

    private boolean isBlankString(Object value) {
        String string;
        return value instanceof String && (string = (String)value).isBlank();
    }
}

